/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.coolsimulations.SurvivalPlus.api.SPCompatibilityManager;
import net.coolsimulations.SurvivalPlus.api.SPItems;
import net.coolsimulations.SurvivalPlus.api.item.SPItemTier;
import net.doubledoordev.lumberjack.LumberjackConfig;
import net.doubledoordev.lumberjack.util.EventHandler;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SurvivalPlusLumberjack {
    public static void init() {
        if (SPCompatibilityManager.isLumberjackLoaded()) {
            SPItems.bronze_lumberaxe = (Item)new SPItemLumberAxe(SPItemTier.bronzeToolMaterial).setRegistryName(new ResourceLocation("lumberjack", "bronze_lumberaxe"));
            SPItems.titanium_lumberaxe = (Item)new SPItemLumberAxe(SPItemTier.titaniumToolMaterial).setRegistryName(new ResourceLocation("lumberjack", "titanium_lumberaxe"));
        }
    }

    public static void register() {
        SurvivalPlusLumberjack.registerItem(SPItems.bronze_lumberaxe);
        SurvivalPlusLumberjack.registerItem(SPItems.titanium_lumberaxe);
    }

    public static void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public static class SPEventHandler
    extends EventHandler {
        private HashMultimap<UUID, BlockPos> pointMap = HashMultimap.create();
        private HashMultimap<UUID, BlockPos> nextMap = HashMultimap.create();

        @SubscribeEvent
        public void tickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            if (event.side != LogicalSide.SERVER) {
                return;
            }
            UUID uuid = event.player.func_110124_au();
            if (!this.nextMap.containsKey((Object)uuid) || this.nextMap.get((Object)uuid).isEmpty()) {
                return;
            }
            int i = 0;
            for (BlockPos point : ImmutableSet.copyOf((Collection)this.nextMap.get((Object)uuid))) {
                ((ServerPlayerEntity)event.player).field_71134_c.func_180237_b(point);
                this.nextMap.remove((Object)uuid, (Object)point);
                if (i++ <= (Integer)LumberjackConfig.GENERAL.tickLimit.get()) continue;
                break;
            }
            if (this.pointMap.get((Object)uuid).size() > (Integer)LumberjackConfig.GENERAL.totalLimit.get()) {
                this.nextMap.removeAll((Object)uuid);
            }
            if (!this.nextMap.containsKey((Object)uuid) || !this.nextMap.get((Object)uuid).isEmpty()) {
                this.pointMap.removeAll((Object)uuid);
            }
        }

        @SubscribeEvent
        public void breakEvent(BlockEvent.BreakEvent event) {
            PlayerEntity player = event.getPlayer();
            if (player == null) {
                return;
            }
            UUID uuid = player.func_110124_au();
            BlockState state = event.getState();
            if (!(state.func_185904_a() == Material.field_151575_d || ((Boolean)LumberjackConfig.GENERAL.leaves.get()).booleanValue() && state.func_185904_a() == Material.field_151584_j)) {
                return;
            }
            ItemStack itemStack = player.func_184614_ca();
            if (itemStack == ItemStack.field_190927_a || !(itemStack.func_77973_b() instanceof SPItemLumberAxe)) {
                return;
            }
            this.pointMap.put((Object)uuid, (Object)event.getPos());
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                        boolean isLeaves;
                        BlockPos newPoint = event.getPos().func_177982_a(offsetX, offsetY, offsetZ);
                        if (this.nextMap.containsEntry((Object)uuid, (Object)newPoint) || this.pointMap.containsEntry((Object)uuid, (Object)newPoint)) continue;
                        BlockState newBlockState = event.getWorld().func_180495_p(newPoint);
                        boolean bl = isLeaves = (Boolean)LumberjackConfig.GENERAL.leaves.get() != false && newBlockState.func_185904_a() == Material.field_151584_j;
                        if (((Integer)LumberjackConfig.GENERAL.mode.get() != 0 || !isLeaves && newBlockState.func_177230_c() != state.func_177230_c()) && ((Integer)LumberjackConfig.GENERAL.mode.get() != 1 || !isLeaves && newBlockState.func_185904_a() != Material.field_151575_d)) continue;
                        this.nextMap.put((Object)uuid, (Object)newPoint);
                    }
                }
            }
        }
    }

    public static class SPItemLumberAxe
    extends AxeItem {
        public SPItemLumberAxe(IItemTier itemTier) {
            super(itemTier, itemTier.func_200929_c(), itemTier.func_200928_b(), new Item.Properties().func_200916_a(ItemGroup.field_78040_i).addToolType(ToolType.AXE, itemTier.func_200925_d()));
        }

        public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
            return stack != ItemStack.field_190927_a && worldIn != null && (Material.field_151584_j.equals(state.func_185904_a()) || super.func_179218_a(stack, worldIn, state, pos, entityLiving));
        }
    }
}

