/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.coolsimulations.SurvivalPlus.api.SPConfig;
import net.coolsimulations.SurvivalPlus.api.SPItems;
import net.coolsimulations.SurvivalPlus.api.SPReference;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusUpdateHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class SurvivalPlusEventHandler {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("survivalplus")) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onplayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        final ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        CompoundNBT entityData = player.getPersistentData();
        AdvancementManager manager = player.func_184102_h().func_191949_aK();
        Advancement install = manager.func_192778_a(new ResourceLocation("survivalplus", "survivalplus/install"));
        boolean isDone = false;
        Timer timer = new Timer();
        if (install != null && player.func_192039_O().func_192747_a(install).func_192108_b()) {
            isDone = true;
        }
        if (!(entityData.func_74767_n("sp.firstJoin") || isDone || ((Boolean)SPConfig.disableThanks.get()).booleanValue())) {
            entityData.func_74757_a("sp.firstJoin", true);
            if (!player.field_70170_p.field_72995_K) {
                TranslationTextComponent installInfo = new TranslationTextComponent("advancements.sp.install.display1", new Object[0]);
                installInfo.func_150256_b().func_150238_a(TextFormatting.GOLD);
                installInfo.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("advancements.sp.install.display2", new Object[0])));
                installInfo.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://curseforge.com/minecraft/mc-mods/survivalplus"));
                player.func_145747_a((ITextComponent)installInfo);
                final TranslationTextComponent discord = new TranslationTextComponent("sp.discord.display1", new Object[0]);
                discord.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
                discord.func_150256_b().func_150227_a(Boolean.valueOf(true));
                for (int i = 0; i < SPReference.MOD_ADDON_NAMES.size(); ++i) {
                    String name = LanguageMap.func_74808_a().func_74805_b(SPReference.MOD_ADDON_NAMES.get(i));
                    StringTextComponent formatted = new StringTextComponent(name);
                    formatted.func_150256_b().func_150238_a(TextFormatting.BLUE);
                    formatted.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    StringTextComponent gap = new StringTextComponent(", ");
                    gap.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    discord.func_150257_a((ITextComponent)formatted);
                    if (i + 1 == SPReference.MOD_ADDON_NAMES.size()) continue;
                    discord.func_150257_a((ITextComponent)gap);
                }
                discord.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("sp.discord.display2", new Object[0])));
                discord.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/7DDsHfQ"));
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        player.func_145747_a((ITextComponent)discord);
                    }
                }, 30000L);
            }
        }
        if (SurvivalPlusUpdateHandler.isOld && !((Boolean)SPConfig.disableUpdateCheck.get()).booleanValue()) {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    player.func_145747_a((ITextComponent)SurvivalPlusUpdateHandler.updateInfo);
                    player.func_145747_a((ITextComponent)SurvivalPlusUpdateHandler.updateVersionInfo);
                }
            }, 15000L);
        }
    }

    @SubscribeEvent
    public void villagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() == VillagerProfession.field_221153_c) {
            ((List)trades.get(3)).add(new BasicTrade(2, new ItemStack((IItemProvider)SPItems.beef_pie, 4), 16, 20));
        }
        if (event.getType() == VillagerProfession.field_221156_f) {
            ((List)trades.get(1)).add(new BasicTrade(1, new ItemStack((IItemProvider)SPItems.onion_seeds, 4), 12, 2));
            ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)SPItems.raw_onion, 6), new ItemStack((IItemProvider)Items.field_151166_bC), 16, 5, 0.05f));
        }
        if (event.getType() == VillagerProfession.field_221152_b) {
            ((List)trades.get(2)).add(new BasicTrade(3, new ItemStack((IItemProvider)SPItems.bronze_chestplate), 12, 5, 0.2f));
        }
        if (event.getType() == VillagerProfession.field_221152_b || event.getType() == VillagerProfession.field_221165_o) {
            ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)SPItems.bronze_ingot, 3), new ItemStack((IItemProvider)Items.field_151166_bC), 12, 5, 0.05f));
            ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)SPItems.titanium_ingot, 3), new ItemStack((IItemProvider)Items.field_151166_bC), 12, 10, 0.05f));
        }
    }

    @SubscribeEvent
    public void villagerTrades(WandererTradesEvent event) {
        List trades = event.getGenericTrades();
        trades.add(new BasicTrade(1, new ItemStack((IItemProvider)SPItems.onion_seeds, 4), 12, 20));
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        PlayerEntity entityplayer = event.getPlayer();
        ItemStack itemStackIn = entityplayer.func_184586_b(event.getHand());
        Item item = itemStackIn.func_77973_b();
        if (block instanceof CampfireBlock && ((Boolean)state.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue() && item == Items.field_151133_ar && !entityplayer.field_71075_bZ.field_75098_d) {
            event.getWorld().func_175656_a(event.getPos(), (BlockState)state.func_206870_a((IProperty)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)));
            if (event.getWorld().func_201670_d()) {
                for (int i = 0; i < 20; ++i) {
                    CampfireBlock.func_220098_a((World)event.getWorld(), (BlockPos)event.getPos(), (boolean)((Boolean)state.func_177229_b((IProperty)CampfireBlock.field_220102_c)), (boolean)true);
                }
            } else {
                event.getWorld().func_184133_a((PlayerEntity)null, event.getPos(), SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (itemStackIn.func_190916_E() == 1) {
                if (ItemStack.func_77989_b((ItemStack)entityplayer.func_184592_cb(), (ItemStack)itemStackIn)) {
                    entityplayer.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)SPItems.charcoal_bucket));
                } else {
                    entityplayer.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)SPItems.charcoal_bucket));
                }
            } else if (itemStackIn.func_190916_E() >= 2) {
                itemStackIn.func_190918_g(1);
                boolean flag = entityplayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)SPItems.charcoal_bucket));
                if (!flag) {
                    entityplayer.func_71019_a(new ItemStack((IItemProvider)SPItems.charcoal_bucket), false);
                }
            }
        }
        if (block == Blocks.field_150423_aK && item instanceof ShearsItem && item != Items.field_151097_aZ && !event.getWorld().field_72995_K) {
            Direction direction = event.getFace();
            Direction direction1 = direction.func_176740_k() == Direction.Axis.Y ? entityplayer.func_174811_aO().func_176734_d() : direction;
            event.getWorld().func_184133_a((PlayerEntity)null, event.getPos(), SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getWorld().func_180501_a(event.getPos(), (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((IProperty)CarvedPumpkinBlock.field_196359_a, (Comparable)direction1), 11);
            ItemEntity itementity = new ItemEntity(event.getWorld(), (double)event.getPos().func_177958_n() + 0.5 + (double)direction1.func_82601_c() * 0.65, (double)event.getPos().func_177956_o() + 0.1, (double)event.getPos().func_177952_p() + 0.5 + (double)direction1.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
            itementity.func_213293_j(0.05 * (double)direction1.func_82601_c() + event.getWorld().field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.func_82599_e() + event.getWorld().field_73012_v.nextDouble() * 0.02);
            event.getWorld().func_217376_c((Entity)itementity);
            itemStackIn.func_222118_a(1, (LivingEntity)entityplayer, livingentity -> livingentity.func_213334_d(event.getHand()));
        }
        if (block == Blocks.field_150414_aQ) {
            if (entityplayer.func_184614_ca().func_77973_b() == SPItems.paper_cup || entityplayer.func_184592_cb().func_77973_b() == SPItems.paper_cup || entityplayer.func_184614_ca().func_77973_b() == SPItems.cupcake || entityplayer.func_184592_cb().func_77973_b() == SPItems.cupcake) {
                event.setCanceled(true);
            }
            if (entityplayer.func_184586_b(event.getHand()).func_77973_b() == SPItems.paper_cup && !event.getWorld().field_72995_K) {
                int bites = (Integer)state.func_177229_b((IProperty)CakeBlock.field_176589_a);
                if (bites < 6) {
                    event.getWorld().func_180501_a(event.getPos(), (BlockState)state.func_206870_a((IProperty)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    event.getWorld().func_217377_a(event.getPos(), false);
                }
                if (!entityplayer.func_184812_l_()) {
                    if (itemStackIn.func_190916_E() == 1) {
                        if (ItemStack.func_77989_b((ItemStack)entityplayer.func_184592_cb(), (ItemStack)itemStackIn)) {
                            entityplayer.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)SPItems.cupcake));
                        } else {
                            entityplayer.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)SPItems.cupcake));
                        }
                    } else if (itemStackIn.func_190916_E() >= 2) {
                        itemStackIn.func_190918_g(1);
                        boolean flag = entityplayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)SPItems.cupcake));
                        if (!flag) {
                            entityplayer.func_71019_a(new ItemStack((IItemProvider)SPItems.cupcake), false);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void tripWireBreak(BlockEvent.BreakEvent event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        PlayerEntity entityplayer = event.getPlayer();
        if (block instanceof TripWireBlock && !event.getWorld().func_201670_d() && !entityplayer.func_184614_ca().func_190926_b() && entityplayer.func_184614_ca().func_77973_b() instanceof ShearsItem && entityplayer.func_184614_ca().func_77973_b() != Items.field_151097_aZ) {
            event.getWorld().func_180501_a(event.getPos(), (BlockState)state.func_206870_a((IProperty)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    @SubscribeEvent
    public void coolsimChat(ServerChatEvent event) {
        TranslationTextComponent coolsim = new TranslationTextComponent("sp.coolsim.creator", new Object[0]);
        coolsim.func_150256_b().func_150238_a(TextFormatting.GOLD);
        if (event.getPlayer().func_110124_au().equals(UUID.fromString("54481257-7b6d-4c8e-8aac-ca6f864e1412")) && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(event.getUsername()) != null) {
            event.setComponent((ITextComponent)new StringTextComponent(coolsim.func_150254_d() + " <" + ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(event.getUsername()).func_145748_c_().func_150254_d() + "> " + event.getMessage()));
        }
    }

    @SubscribeEvent
    public void coolsimReceivedChat(ClientChatReceivedEvent event) {
        TranslationTextComponent coolsim = new TranslationTextComponent("sp.coolsim.creator", new Object[0]);
        coolsim.func_150256_b().func_150238_a(TextFormatting.GOLD);
        String coolsimFormatted = "coolsim";
        if (event.getMessage().func_150254_d().contains("coolsim")) {
            int index = event.getMessage().func_150254_d().indexOf("coolsim");
            try {
                coolsimFormatted = event.getMessage().func_150254_d().substring(index - 2, index + 9);
                if (StringUtils.countMatches((CharSequence)coolsimFormatted, (CharSequence)"\u00a7") != 2) {
                    coolsimFormatted = "coolsim";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TranslationTextComponent playerJoined = new TranslationTextComponent("multiplayer.player.joined", new Object[]{coolsimFormatted});
        playerJoined.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        TranslationTextComponent playerLeft = new TranslationTextComponent("multiplayer.player.left", new Object[]{coolsimFormatted});
        playerLeft.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        TranslationTextComponent coolsimJoined = new TranslationTextComponent("sp.coolsim.joined", new Object[]{coolsimFormatted});
        coolsimJoined.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        TranslationTextComponent coolsimLeft = new TranslationTextComponent("sp.coolsim.left", new Object[]{coolsimFormatted});
        coolsimLeft.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        if (SurvivalPlusEventHandler.replaceFormattingCodes(event.getMessage()).equals(SurvivalPlusEventHandler.replaceFormattingCodes((ITextComponent)playerJoined))) {
            event.setMessage((ITextComponent)coolsimJoined);
        }
        if (SurvivalPlusEventHandler.replaceFormattingCodes(event.getMessage()).equals(SurvivalPlusEventHandler.replaceFormattingCodes((ITextComponent)playerLeft))) {
            event.setMessage((ITextComponent)coolsimLeft);
        }
        if (SurvivalPlusEventHandler.replaceFormattingCodes(event.getMessage()).startsWith("[coolsim]")) {
            event.setMessage((ITextComponent)new StringTextComponent(event.getMessage().func_150254_d().replaceFirst("\\[", coolsim.func_150254_d() + " [")));
        }
    }

    @SubscribeEvent
    public void coolsimDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && event.getEntity().func_110124_au().equals(UUID.fromString("54481257-7b6d-4c8e-8aac-ca6f864e1412")) && event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            ServerPlayerEntity attacker = (ServerPlayerEntity)event.getSource().func_76346_g();
            ItemStack coolsimHead = SurvivalPlusEventHandler.getcoolsimHead();
            if (coolsimHead != null) {
                SurvivalPlusEventHandler.dropItem(coolsimHead, (PlayerEntity)attacker);
            } else {
                TranslationTextComponent error = new TranslationTextComponent("sp.coolsim.error", new Object[0]);
                error.func_150256_b().func_150238_a(TextFormatting.RED);
                attacker.func_145747_a((ITextComponent)error);
            }
        }
    }

    public static ItemStack getcoolsimHead() {
        String texture = "eyJ0aW1lc3RhbXAiOjE1NzYxMTM5OTc5ODUsInByb2ZpbGVJZCI6IjU0NDgxMjU3N2I2ZDRjOGU4YWFjY2E2Zjg2NGUxNDEyIiwicHJvZmlsZU5hbWUiOiJjb29sc2ltIiwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzdmMDkwM2QxOGMyZTE4YmQzYzBiMDk5YmIzZGFkNmVjYTQ2ZDBjMzdkZjJkM2FlMjljYzAwOWYwN2I5OTM3NmYifX19";
        String id = new UUID(texture.hashCode(), texture.hashCode()).toString();
        ItemStack playerhead = new ItemStack((IItemProvider)Items.field_196184_dx);
        TranslationTextComponent headName = new TranslationTextComponent("block.minecraft.player_head.named", new Object[]{"coolsim"});
        headName.func_150256_b().func_150217_b(Boolean.valueOf(true));
        CompoundNBT skullOwner = new CompoundNBT();
        skullOwner.func_74778_a("Id", id);
        CompoundNBT properties = new CompoundNBT();
        ListNBT textures = new ListNBT();
        CompoundNBT tex = new CompoundNBT();
        tex.func_74778_a("Value", texture);
        textures.add((Object)tex);
        properties.func_218657_a("textures", (INBT)textures);
        skullOwner.func_218657_a("Properties", (INBT)properties);
        playerhead.func_77983_a("SkullOwner", (INBT)skullOwner);
        playerhead.func_200302_a((ITextComponent)headName);
        return playerhead;
    }

    public static void dropItem(ItemStack stack, PlayerEntity player) {
        boolean bl = player.field_71071_by.func_70441_a(stack);
        if (bl && stack.func_190926_b()) {
            stack.func_190920_e(1);
            ItemEntity itementity1 = player.func_71019_a(stack, false);
            if (itementity1 != null) {
                itementity1.func_174870_v();
            }
            player.field_70170_p.func_184148_a((PlayerEntity)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.field_71069_bz.func_75142_b();
        } else {
            ItemEntity itementity = player.func_71019_a(stack, false);
            if (itementity != null) {
                itementity.func_174868_q();
                itementity.func_200217_b(player.func_110124_au());
            }
        }
    }

    public static String replaceFormattingCodes(ITextComponent component) {
        String text = component.func_150254_d();
        if (text.contains("\u00a7")) {
            for (int i = 0; i <= StringUtils.countMatches((CharSequence)text, (CharSequence)"\u00a7"); ++i) {
                text = text.substring(0, text.indexOf("\u00a7")) + text.substring(text.indexOf("\u00a7") + 2);
            }
        }
        return text;
    }
}

