/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core.util;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.coolsimulations.SurvivalPlus.api.SPBlocks;
import net.coolsimulations.SurvivalPlus.api.SPCompatibilityManager;
import net.coolsimulations.SurvivalPlus.api.SPItems;
import net.coolsimulations.SurvivalPlus.api.SPTags;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;

@EMCMapper
public class SurvivalPlusEMCValues
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final Map<NormalizedSimpleStack, Long> customEmcValues = new HashMap<NormalizedSimpleStack, Long>();

    public String getName() {
        return "SurvivalPlusMapper";
    }

    public String getDescription() {
        return "Adds EMC Values to SurvivalPlus Items.";
    }

    public static void init() {
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.INGOTS_COPPER), 55L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.INGOTS_TIN), 256L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.INGOTS_TITANIUM), 2048L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.CROPS_ONION), 64L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.SEEDS_ONION), 32L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_AMETHYST), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_RUBY), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_TOPAZ), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_SAPPHIRE), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_PEARL), 2048L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createTag(SPTags.Items.GEMS_SPINEL), 2048L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.copper_ingot), 55L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.tin_ingot), 256L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.titanium_ingot), 2048L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.raw_onion), 64L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.onion_seeds), 32L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.amethyst), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.ruby), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.topaz), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.sapphire), 512L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.pearl), 2048L);
        SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPBlocks.spinel), 2048L);
        if (SPCompatibilityManager.isIc2Loaded()) {
            SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.crushed_titanium_ore), 1024L);
            SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.purified_titanium_ore), 1024L);
            SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.titanium_dust), 1024L);
            SurvivalPlusEMCValues.registerCustomEMC((NormalizedSimpleStack)NSSItem.createItem((IItemProvider)SPItems.tiny_titanium_pile), 113L);
        }
    }

    public static void registerCustomEMC(@Nonnull NormalizedSimpleStack stack, long emcValue) {
        customEmcValues.put(stack, emcValue);
    }

    public static void unregisterNSS(@Nonnull NormalizedSimpleStack stack) {
        customEmcValues.remove(stack);
    }

    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, IResourceManager resourceManager) {
        for (Map.Entry<NormalizedSimpleStack, Long> entry : customEmcValues.entrySet()) {
            NormalizedSimpleStack normStack = entry.getKey();
            long value = entry.getValue();
            mapper.setValueBefore((Object)normStack, (Comparable)Long.valueOf(value));
        }
    }
}

