/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core.init;

import java.util.HashMap;
import java.util.Map;
import net.coolsimulations.SurvivalPlus.api.SPCompatibilityManager;
import net.coolsimulations.SurvivalPlus.api.SPItems;
import net.coolsimulations.SurvivalPlus.core.blocks.BlockCardboard;
import net.coolsimulations.SurvivalPlus.core.blocks.BlockCardboardLantern;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalplus", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FuelHandler {
    private static Map<Item, Integer> armor_fuel = new HashMap<Item, Integer>();

    public static void registerArmorFuels() {
        FuelHandler.addArmorFuels(SPItems.oak);
        FuelHandler.addArmorFuels(SPItems.spruce);
        FuelHandler.addArmorFuels(SPItems.birch);
        FuelHandler.addArmorFuels(SPItems.jungle);
        FuelHandler.addArmorFuels(SPItems.acacia);
        FuelHandler.addArmorFuels(SPItems.dark_oak);
        if (SPCompatibilityManager.isBopLoaded()) {
            FuelHandler.addArmorFuels(SPItems.cherry);
            FuelHandler.addArmorFuels(SPItems.dead);
            FuelHandler.addArmorFuels(SPItems.ethereal);
            FuelHandler.addArmorFuels(SPItems.fir);
            FuelHandler.addArmorFuels(SPItems.hellbark);
            FuelHandler.addArmorFuels(SPItems.jacaranda);
            FuelHandler.addArmorFuels(SPItems.magic);
            FuelHandler.addArmorFuels(SPItems.mahogany);
            FuelHandler.addArmorFuels(SPItems.palm);
            FuelHandler.addArmorFuels(SPItems.redwood);
            FuelHandler.addArmorFuels(SPItems.umbran);
            FuelHandler.addArmorFuels(SPItems.willow);
        }
        if (SPCompatibilityManager.isBopExtrasLoaded()) {
            FuelHandler.addArmorFuels(SPItems.ebony);
            FuelHandler.addArmorFuels(SPItems.eucalyptus);
            FuelHandler.addArmorFuels(SPItems.mangrove);
            FuelHandler.addArmorFuels(SPItems.pine);
            FuelHandler.addArmorFuels(SPItems.sacred_oak);
        }
        if (SPCompatibilityManager.isForestryLoaded()) {
            FuelHandler.addArmorFuels(SPItems.desert_acacia);
            FuelHandler.addArmorFuels(SPItems.balsa);
            FuelHandler.addArmorFuels(SPItems.baobab);
            FuelHandler.addArmorFuels(SPItems.cherry_forestry);
            FuelHandler.addArmorFuels(SPItems.chestnut);
            FuelHandler.addArmorFuels(SPItems.citrus);
            FuelHandler.addArmorFuels(SPItems.cocobolo);
            FuelHandler.addArmorFuels(SPItems.ebony_forestry);
            FuelHandler.addArmorFuels(SPItems.giant_sequoia);
            FuelHandler.addArmorFuels(SPItems.greenheart);
            FuelHandler.addArmorFuels(SPItems.ipe);
            FuelHandler.addArmorFuels(SPItems.kapok);
            FuelHandler.addArmorFuels(SPItems.larch);
            FuelHandler.addArmorFuels(SPItems.lime);
            FuelHandler.addArmorFuels(SPItems.mahoe);
            FuelHandler.addArmorFuels(SPItems.mahogany_forestry);
            FuelHandler.addArmorFuels(SPItems.maple);
            FuelHandler.addArmorFuels(SPItems.padauk);
            FuelHandler.addArmorFuels(SPItems.palm_forestry);
            FuelHandler.addArmorFuels(SPItems.papaya);
            FuelHandler.addArmorFuels(SPItems.pine_forestry);
            FuelHandler.addArmorFuels(SPItems.plum);
            FuelHandler.addArmorFuels(SPItems.poplar);
            FuelHandler.addArmorFuels(SPItems.sequoia);
            FuelHandler.addArmorFuels(SPItems.teak);
            FuelHandler.addArmorFuels(SPItems.walnut);
            FuelHandler.addArmorFuels(SPItems.wenge);
            FuelHandler.addArmorFuels(SPItems.willow_forestry);
            FuelHandler.addArmorFuels(SPItems.zebrawood);
        }
        if (SPCompatibilityManager.isIc2Loaded()) {
            FuelHandler.addArmorFuels(SPItems.rubber);
        }
        if (SPCompatibilityManager.isTraverseLoaded()) {
            FuelHandler.addArmorFuels(SPItems.fir_traverse);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Block block;
        Item item;
        ItemStack fuel = event.getItemStack();
        for (Map.Entry<Item, Integer> entry : armor_fuel.entrySet()) {
            if (fuel.func_77973_b() != entry.getKey()) continue;
            event.setBurnTime(entry.getValue().intValue());
            return;
        }
        if (SPCompatibilityManager.isBambooModsLoaded()) {
            if (fuel.func_77973_b() == SPItems.bamboo_helmet) {
                event.setBurnTime(250);
            }
            if (fuel.func_77973_b() == SPItems.bamboo_chestplate) {
                event.setBurnTime(400);
            }
            if (fuel.func_77973_b() == SPItems.bamboo_leggings) {
                event.setBurnTime(350);
            }
            if (fuel.func_77973_b() == SPItems.bamboo_boots) {
                event.setBurnTime(200);
            }
        }
        if (fuel.func_77973_b() == SPItems.paper_cup) {
            event.setBurnTime(200);
        }
        if (fuel.func_77973_b() == SPItems.charcoal_bucket) {
            event.setBurnTime(4800);
        }
        if ((item = fuel.func_77973_b()) instanceof BlockItem && Block.func_149634_a((Item)item) != Blocks.field_150350_a && (block = Block.func_149634_a((Item)item)) instanceof BlockCardboard) {
            event.setBurnTime(800);
            if (block instanceof BlockCardboardLantern) {
                event.setBurnTime(1600);
            }
        }
    }

    private static void addArmorFuels(NonNullList<ItemStack> item) {
        for (int i = 0; i < item.size(); ++i) {
            int value;
            if (!(((ItemStack)item.get(i)).func_77973_b() instanceof ArmorItem)) continue;
            EquipmentSlotType slotType = ((ArmorItem)((ItemStack)item.get(i)).func_77973_b()).func_185083_B_();
            switch (slotType) {
                case HEAD: {
                    value = 1500;
                    break;
                }
                case CHEST: {
                    value = 2400;
                    break;
                }
                case LEGS: {
                    value = 2100;
                    break;
                }
                case FEET: {
                    value = 1200;
                    break;
                }
                default: {
                    value = 0;
                }
            }
            armor_fuel.put(((ItemStack)item.get(i)).func_77973_b(), value);
        }
    }
}

