/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.coolsimulations.SurvivalPlus.api.SPBlocks;
import net.coolsimulations.SurvivalPlus.core.blocks.BlockCardboard;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.Tag;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class BlockCardboardLantern
extends BlockCardboard
implements IWaterLoggable {
    protected static final VoxelShape CARDBOARD_LANTERN_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.75, (double)0.0, (double)5.75, (double)10.25, (double)1.0, (double)10.25), Block.func_208617_a((double)5.75, (double)5.0, (double)5.75, (double)10.25, (double)6.0, (double)10.25), Block.func_208617_a((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), Block.func_208617_a((double)6.75, (double)6.0, (double)6.75, (double)9.25, (double)6.25, (double)9.25)});
    protected static final VoxelShape CARDBOARD_LANTERN_HANGING_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.75, (double)1.0, (double)5.75, (double)10.25, (double)2.0, (double)10.25), Block.func_208617_a((double)5.75, (double)6.0, (double)5.75, (double)10.25, (double)7.0, (double)10.25), Block.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.func_208617_a((double)6.75, (double)7.0, (double)6.75, (double)9.25, (double)7.25, (double)9.25), Block.func_208617_a((double)7.75, (double)8.0, (double)7.75, (double)8.25, (double)16.0, (double)8.25)});
    protected static final VoxelShape CARDBOARD_PAD_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)-1.5, (double)6.0, (double)10.0, (double)3.5, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.75, (double)-1.5, (double)5.75, (double)10.25, (double)-0.5, (double)10.25), Block.func_208617_a((double)5.75, (double)3.5, (double)5.75, (double)10.25, (double)4.5, (double)10.25), Block.func_208617_a((double)7.0, (double)4.5, (double)7.0, (double)9.0, (double)5.5, (double)9.0), Block.func_208617_a((double)6.75, (double)4.5, (double)6.75, (double)9.25, (double)4.75, (double)9.25), Block.func_208617_a((double)5.0, (double)-1.5, (double)5.0, (double)11.0, (double)-2.5, (double)11.0), Block.func_208617_a((double)4.0, (double)-1.0, (double)11.0, (double)5.0, (double)-2.0, (double)5.0), Block.func_208617_a((double)12.0, (double)-1.0, (double)4.0, (double)4.0, (double)-2.0, (double)5.0), Block.func_208617_a((double)12.0, (double)-1.0, (double)11.0, (double)4.0, (double)-2.0, (double)12.0), Block.func_208617_a((double)12.0, (double)-1.0, (double)5.0, (double)11.0, (double)-2.0, (double)11.0)});
    protected static final VoxelShape CARDBOARD_LANTERN_NORTH_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)2.0, (double)8.0, (double)10.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.75, (double)1.0, (double)7.75, (double)10.25, (double)2.0, (double)12.25), Block.func_208617_a((double)5.75, (double)6.0, (double)7.75, (double)10.25, (double)7.0, (double)12.25), Block.func_208617_a((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)8.0, (double)11.0), Block.func_208617_a((double)6.75, (double)7.0, (double)8.75, (double)9.25, (double)7.25, (double)11.25), Block.func_208617_a((double)7.75, (double)6.25, (double)7.75, (double)8.25, (double)6.75, (double)15.75), Block.func_208617_a((double)7.5, (double)6.0, (double)15.75, (double)8.5, (double)7.0, (double)16.0), Block.func_208617_a((double)7.75, (double)1.25, (double)7.75, (double)8.25, (double)1.75, (double)15.75), Block.func_208617_a((double)7.5, (double)1.0, (double)15.75, (double)8.5, (double)2.0, (double)16.0), Block.func_208617_a((double)7.75, (double)1.75, (double)14.25, (double)8.25, (double)6.25, (double)14.75)});
    protected static final VoxelShape CARDBOARD_LANTERN_SOUTH_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.0, (double)2.0, (double)4.0, (double)10.0, (double)6.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)5.75, (double)1.0, (double)3.75, (double)10.25, (double)2.0, (double)8.25), Block.func_208617_a((double)5.75, (double)6.0, (double)3.75, (double)10.25, (double)7.0, (double)8.25), Block.func_208617_a((double)7.0, (double)7.0, (double)5.0, (double)9.0, (double)8.0, (double)7.0), Block.func_208617_a((double)6.75, (double)7.0, (double)4.75, (double)9.25, (double)7.25, (double)7.25), Block.func_208617_a((double)7.75, (double)6.25, (double)0.25, (double)8.25, (double)6.75, (double)3.75), Block.func_208617_a((double)7.5, (double)6.0, (double)0.0, (double)8.5, (double)7.0, (double)0.25), Block.func_208617_a((double)7.75, (double)1.25, (double)0.25, (double)8.25, (double)1.75, (double)3.75), Block.func_208617_a((double)7.5, (double)1.0, (double)0.0, (double)8.5, (double)2.0, (double)0.25), Block.func_208617_a((double)7.75, (double)1.75, (double)1.25, (double)8.25, (double)6.25, (double)1.75)});
    protected static final VoxelShape CARDBOARD_LANTERN_EAST_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)2.0, (double)6.0, (double)8.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)3.75, (double)1.0, (double)5.75, (double)8.25, (double)2.0, (double)10.25), Block.func_208617_a((double)3.75, (double)6.0, (double)5.75, (double)8.25, (double)7.0, (double)10.25), Block.func_208617_a((double)5.0, (double)7.0, (double)7.0, (double)7.0, (double)8.0, (double)9.0), Block.func_208617_a((double)4.75, (double)7.0, (double)6.75, (double)7.25, (double)7.25, (double)9.25), Block.func_208617_a((double)0.25, (double)6.25, (double)7.75, (double)3.75, (double)6.75, (double)8.25), Block.func_208617_a((double)0.0, (double)6.0, (double)7.5, (double)0.25, (double)7.0, (double)8.5), Block.func_208617_a((double)0.0, (double)1.25, (double)7.75, (double)0.25, (double)1.75, (double)8.25), Block.func_208617_a((double)0.0, (double)1.0, (double)7.5, (double)0.25, (double)2.0, (double)8.5), Block.func_208617_a((double)1.25, (double)1.75, (double)7.75, (double)1.75, (double)6.25, (double)8.25)});
    protected static final VoxelShape CARDBOARD_LANTERN_WEST_AABB = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)8.0, (double)2.0, (double)6.0, (double)12.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)7.75, (double)1.0, (double)5.75, (double)12.25, (double)2.0, (double)10.25), Block.func_208617_a((double)7.75, (double)6.0, (double)5.75, (double)12.25, (double)7.0, (double)10.25), Block.func_208617_a((double)9.0, (double)7.0, (double)7.0, (double)11.0, (double)8.0, (double)9.0), Block.func_208617_a((double)8.75, (double)7.0, (double)6.75, (double)11.25, (double)7.25, (double)9.25), Block.func_208617_a((double)15.75, (double)6.25, (double)7.75, (double)9.25, (double)6.75, (double)8.25), Block.func_208617_a((double)16.0, (double)6.0, (double)7.5, (double)15.75, (double)7.0, (double)8.5), Block.func_208617_a((double)15.75, (double)1.25, (double)7.75, (double)9.25, (double)1.75, (double)8.25), Block.func_208617_a((double)16.0, (double)1.0, (double)7.5, (double)15.75, (double)2.0, (double)8.5), Block.func_208617_a((double)14.75, (double)1.75, (double)7.75, (double)14.25, (double)6.25, (double)8.25)});
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty FLOATING = BooleanProperty.func_177716_a((String)"floating");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected boolean isDyed;

    public BlockCardboardLantern(MaterialColor colour, boolean isDyed) {
        super(colour);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)FLOATING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isDyed = isDyed;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    @Override
    public int func_149750_m(BlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            return 14;
        }
        return this.field_149784_t;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction enumfacing = (Direction)state.func_177229_b((IProperty)FACING);
        boolean isFloating = (Boolean)state.func_177229_b((IProperty)FLOATING);
        if (isFloating) {
            if (enumfacing == Direction.DOWN) {
                return CARDBOARD_LANTERN_HANGING_AABB;
            }
            return CARDBOARD_PAD_AABB;
        }
        switch (enumfacing) {
            case UP: {
                return CARDBOARD_LANTERN_AABB;
            }
            case EAST: {
                return CARDBOARD_LANTERN_EAST_AABB;
            }
            case SOUTH: {
                return CARDBOARD_LANTERN_SOUTH_AABB;
            }
            case WEST: {
                return CARDBOARD_LANTERN_WEST_AABB;
            }
            case NORTH: {
                return CARDBOARD_LANTERN_NORTH_AABB;
            }
            case DOWN: {
                return CARDBOARD_LANTERN_HANGING_AABB;
            }
        }
        return CARDBOARD_PAD_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction enumfacing = (Direction)stateIn.func_177229_b((IProperty)FACING);
        boolean isFloating = (Boolean)stateIn.func_177229_b((IProperty)FLOATING);
        boolean isWaterLogged = (Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.21875;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (!isWaterLogged) {
            if (isFloating) {
                if (enumfacing == Direction.DOWN) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 + 0.0625, d2, 0.0, 0.0, 0.0);
                } else {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 - 0.03125, d2, 0.0, 0.0, 0.0);
                }
            } else {
                switch (enumfacing) {
                    case UP: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 - 0.125, d1 + 0.0625, d2, 0.0, 0.0, 0.0);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 + 0.0625, d2 - 0.125, 0.0, 0.0, 0.0);
                        break;
                    }
                    case WEST: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.125, d1 + 0.0625, d2, 0.0, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 + 0.0625, d2 + 0.125, 0.0, 0.0, 0.0);
                        break;
                    }
                    case DOWN: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1 + 0.0625, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!this.isDyed) {
            boolean success = false;
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_WHITE, SPBlocks.cardboard_lantern_white);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_LIGHT_GRAY, SPBlocks.cardboard_lantern_light_grey);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_GRAY, SPBlocks.cardboard_lantern_grey);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_BLACK, SPBlocks.cardboard_lantern_black);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_RED, SPBlocks.cardboard_lantern_red);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_ORANGE, SPBlocks.cardboard_lantern_orange);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_YELLOW, SPBlocks.cardboard_lantern_yellow);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_LIME, SPBlocks.cardboard_lantern_lime);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_GREEN, SPBlocks.cardboard_lantern_green);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_LIGHT_BLUE, SPBlocks.cardboard_lantern_light_blue);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_CYAN, SPBlocks.cardboard_lantern_cyan);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_BLUE, SPBlocks.cardboard_lantern_blue);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_PURPLE, SPBlocks.cardboard_lantern_purple);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_MAGENTA, SPBlocks.cardboard_lantern_magenta);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_PINK, SPBlocks.cardboard_lantern_pink);
            }
            if (!success) {
                success = this.checkDye(worldIn, pos, state, playerIn, itemStackIn, (Tag<Item>)Tags.Items.DYES_BROWN, SPBlocks.cardboard_lantern_brown);
            }
            state.func_196956_a(hit.func_216354_b(), state, (IWorld)worldIn, pos, pos);
            return success;
        }
        state.func_196956_a(hit.func_216354_b(), state, (IWorld)worldIn, pos, pos);
        return false;
    }

    protected boolean checkDye(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn, ItemStack stack, Tag<Item> tag, Block dyeBlock) {
        for (Item dye : tag.func_199885_a()) {
            if (dye != stack.func_77973_b() || tag == null) continue;
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)dyeBlock.func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)FLOATING, state.func_177229_b((IProperty)FLOATING))).func_206870_a((IProperty)WATERLOGGED, state.func_177229_b((IProperty)WATERLOGGED)), 3);
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos fromPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!BlockCardboardLantern.canPlaceBlock(worldIn.func_201672_e(), pos, (Direction)state.func_177229_b((IProperty)FACING)) && !((Boolean)state.func_177229_b((IProperty)FLOATING)).booleanValue()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (state.func_177229_b((IProperty)FACING) == Direction.DOWN && !BlockCardboardLantern.isValidPos(worldIn.func_201672_e(), fromPos, Direction.DOWN)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((IProperty)FLOATING)).booleanValue() && !this.canBlockStay(worldIn.func_201672_e(), pos, state)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, BlockState state) {
        BlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        IFluidState ifluidstate = worldIn.func_204610_c(pos.func_177977_b());
        Material material = iblockstate.func_185904_a();
        return ifluidstate.func_206886_c() == Fluids.field_204546_a || material == Material.field_151588_w || material == Material.field_151598_x || iblockstate.func_177230_c() instanceof CauldronBlock && (Integer)iblockstate.func_177229_b((IProperty)CauldronBlock.field_176591_a) == 3;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (direction == Direction.UP) {
            if (block instanceof TrapDoorBlock && !BlockCardboardLantern.isTrapdoorValid(iblockstate, direction)) {
                return false;
            }
            if (block instanceof SlabBlock && !BlockCardboardLantern.isSlabValid(iblockstate, direction)) {
                return false;
            }
            return !(block instanceof BlockCardboardLantern) || ((Direction)iblockstate.func_177229_b((IProperty)FACING)).func_176740_k() != Direction.Axis.Y;
        }
        if (direction != Direction.DOWN) {
            return iblockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction.func_176734_d()) && BlockCardboardLantern.func_220056_d((BlockState)iblockstate, (IBlockReader)worldIn, (BlockPos)blockpos, (Direction)direction);
        }
        return BlockCardboardLantern.isValidPos(worldIn, pos, Direction.DOWN);
    }

    protected boolean canFloat(World worldIn, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        return direction == Direction.UP && (iblockstate.func_177230_c() == Blocks.field_150355_j || (iblockstate.func_185904_a() == Material.field_151588_w || iblockstate.func_185904_a() == Material.field_151598_x) && direction != Direction.DOWN || iblockstate.func_177230_c() instanceof CauldronBlock && (Integer)iblockstate.func_177229_b((IProperty)CauldronBlock.field_176591_a) == 3);
    }

    protected boolean isWaterLogged(IWorld worldIn, BlockPos pos) {
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (BlockCardboardLantern.canPlaceBlock(context.func_195991_k(), context.func_195995_a(), context.func_196000_l())) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l())).func_206870_a((IProperty)FLOATING, (Comparable)Boolean.valueOf(this.canFloat(context.func_195991_k(), context.func_195995_a(), context.func_196000_l())))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(this.isWaterLogged((IWorld)context.func_195991_k(), context.func_195995_a())));
        }
        return null;
    }

    protected static boolean isValidPos(World worldIn, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        if (block instanceof TrapDoorBlock) {
            return BlockCardboardLantern.isTrapdoorValid(state, direction);
        }
        if (block instanceof HopperBlock) {
            return false;
        }
        if (block instanceof SlabBlock) {
            return BlockCardboardLantern.isSlabValid(state, direction);
        }
        return !block.isAir(state, (IBlockReader)worldIn, blockpos);
    }

    protected static boolean isTrapdoorValid(BlockState state, Direction facing) {
        return state.func_206869_a().contains(TrapDoorBlock.field_176285_M) && (facing == Direction.UP && state.func_177229_b((IProperty)TrapDoorBlock.field_176285_M) == Half.TOP || facing == Direction.DOWN && state.func_177229_b((IProperty)TrapDoorBlock.field_176285_M) == Half.BOTTOM) && (Boolean)state.func_177229_b((IProperty)TrapDoorBlock.field_176283_b) == false;
    }

    protected static boolean isSlabValid(BlockState state, Direction facing) {
        return state.func_206869_a().contains(SlabBlock.field_196505_a) && (facing == Direction.UP && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP || facing == Direction.DOWN && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) || state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.DOUBLE;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        Random rand = new Random();
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn) + rand.nextInt(10));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, FLOATING, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

