/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.SurvivalPlus.api.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class SPBlockOre
extends Block {
    public final Resource resource;
    public final Boolean experience;

    public SPBlockOre(Resource resource, Boolean dropsXP) {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)Material.field_151576_e.func_151565_r()).func_200948_a(resource.hardness, resource.resistance).func_200947_a(resource.getBlockSoundType()));
        this.resource = resource;
        this.experience = dropsXP;
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public void func_220062_a(BlockState state, World world, BlockPos pos, ItemStack stack) {
        super.func_220062_a(state, world, pos, stack);
    }

    public int getHarvestLevel(BlockState state) {
        return this.resource.harvestLevel;
    }

    public int func_149750_m(BlockState p_getLightValue_1_) {
        return 0;
    }

    protected int getExperience(Random random) {
        if (this.experience.booleanValue()) {
            if (this.resource == Resource.TIER_0) {
                return MathHelper.func_76136_a((Random)random, (int)0, (int)2);
            }
            if (this.resource == Resource.TIER_1) {
                return MathHelper.func_76136_a((Random)random, (int)2, (int)5);
            }
            if (this.resource == Resource.TIER_2) {
                return MathHelper.func_76136_a((Random)random, (int)3, (int)7);
            }
            return this.resource == Resource.TIER_3 ? MathHelper.func_76136_a((Random)random, (int)3, (int)7) : 0;
        }
        return 0;
    }

    public int getExpDrop(BlockState state, IWorldReader reader, BlockPos pos, int p_getExpDrop_4_, int amount) {
        return amount == 0 ? this.getExperience(this.RANDOM) : 0;
    }

    public static enum Resource {
        TIER_0(0, 3.0f, 3.0f, SoundType.field_185851_d, (IItemTier)ItemTier.WOOD),
        TIER_1(1, 3.0f, 3.0f, SoundType.field_185851_d, (IItemTier)ItemTier.STONE),
        TIER_2(2, 3.0f, 3.0f, SoundType.field_185851_d, (IItemTier)ItemTier.IRON),
        TIER_3(3, 3.0f, 3.0f, SoundType.field_185851_d, (IItemTier)ItemTier.DIAMOND);

        public final float hardness;
        public final float resistance;
        private final SoundType soundType;
        public final int harvestLevel;
        public final IItemTier itemTier;

        private Resource(int harvestLevel, float hardness, float resistance, SoundType soundType, IItemTier itemTier) {
            this.hardness = hardness;
            this.resistance = resistance;
            this.soundType = soundType;
            this.harvestLevel = harvestLevel;
            this.itemTier = itemTier;
        }

        public SoundType getBlockSoundType() {
            return this.soundType;
        }
    }
}

