/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.render;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import me.x150.renderer.client.RendererMain;
import me.x150.renderer.render.Renderer2d;
import me.x150.renderer.util.RendererUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVGFile
implements Closeable {
    final String svgSource;
    final int originalWidth;
    final int originalHeight;
    int memoizedGuiScale = -1;
    class_2960 id;

    public SVGFile(String svgSource, int width, int height) {
        this.svgSource = svgSource;
        this.originalWidth = width;
        this.originalHeight = height;
    }

    private void _redraw(float width, float height) {
        if (this.id != null) {
            this.close();
        }
        this.id = RendererUtils.randomIdentifier();
        PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        TranscoderInput transcoderInput = new TranscoderInput((Reader)new StringReader(this.svgSource));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)out);
        try {
            transcoder.transcode(transcoderInput, transcoderOutput);
            byte[] t = out.toByteArray();
            class_1043 tex = new class_1043(class_1011.method_4309((InputStream)new ByteArrayInputStream(t)));
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(this.id, (class_1044)tex));
        }
        catch (Throwable t) {
            RendererMain.LOGGER.error("Failed to render SVG", t);
            this.id = new class_2960("missingno");
        }
    }

    public void render(class_4587 stack, double x, double y, float renderWidth, float renderHeight) {
        int guiScale = RendererUtils.getGuiScale();
        if (this.memoizedGuiScale != guiScale || this.id == null) {
            this.memoizedGuiScale = guiScale;
            this._redraw(this.originalWidth * this.memoizedGuiScale, this.originalHeight * this.memoizedGuiScale);
        }
        Renderer2d.renderTexture(stack, this.id, x, y, renderWidth, renderHeight);
    }

    @Override
    public void close() {
        if (this.id == null) {
            throw new IllegalStateException("Already closed");
        }
        if (this.id.method_12836().equals("renderer")) {
            class_310.method_1551().method_1531().method_4615(this.id);
        }
        this.id = null;
    }
}

