/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import me.x150.renderer.render.Renderer3d;
import me.x150.renderer.util.BufferUtils;
import me.x150.renderer.util.Colors;
import me.x150.renderer.util.RendererUtils;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.Range;
import org.joml.Math;
import org.joml.Matrix4f;

public class Renderer2d {
    private static final class_310 client = class_310.method_1551();
    private static final float[][] roundedCache = new float[][]{new float[3], new float[3], new float[3], new float[3]};

    static void beginScissor(double x, double y, double endX, double endY) {
        double width = endX - x;
        double height = endY - y;
        width = Math.max((double)0.0, (double)width);
        height = Math.max((double)0.0, (double)height);
        float d = (float)client.method_22683().method_4495();
        int ay = (int)(((double)client.method_22683().method_4502() - (y + height)) * (double)d);
        RenderSystem.enableScissor((int)((int)(x * (double)d)), (int)ay, (int)((int)(width * (double)d)), (int)((int)(height * (double)d)));
    }

    static void endScissor() {
        RenderSystem.disableScissor();
    }

    public static void renderTexture(class_4587 matrices, double x0, double y0, double width, double height, float u, float v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        double x1 = x0 + width;
        double y1 = y0 + height;
        double z = 0.0;
        Renderer2d.renderTexturedQuad(matrices.method_23760().method_23761(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    private static void renderTexturedQuad(Matrix4f matrix, double x0, double x1, double y0, double y1, double z, float u0, float u1, float v0, float v1) {
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, (float)x0, (float)y1, (float)z).method_22913(u0, v1).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y0, (float)z).method_22913(u1, v0).method_1344();
        buffer.method_22918(matrix, (float)x0, (float)y0, (float)z).method_22913(u0, v0).method_1344();
        RenderSystem.setShader(class_757::method_34542);
        BufferUtils.draw(buffer);
    }

    public static void renderTexture(class_4587 matrices, double x, double y, double width, double height) {
        Renderer2d.renderTexture(matrices, x, y, width, height, 0.0f, 0.0f, width, height, width, height);
    }

    public static void renderTexture(class_4587 matrices, class_2960 texture, double x, double y, double width, double height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        Renderer2d.renderTexture(matrices, x, y, width, height);
    }

    public static void renderEllipse(class_4587 matrices, Color ellipseColor, double originX, double originY, double radX, double radY, @Range(from=4L, to=360L) int segments) {
        segments = class_3532.method_15340((int)segments, (int)4, (int)360);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float[] colorFloat = Renderer3d.getColor(ellipseColor);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        int i = 0;
        while (i < 360) {
            double radians = Math.toRadians((float)i);
            double sin = Math.sin((double)radians) * radX;
            double cos = Math.cos((double)radians) * radY;
            buffer.method_22918(matrix, (float)(originX + sin), (float)(originY + cos), 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
            i = (int)((double)i + Math.min((double)(360.0 / (double)segments), (double)(360 - i)));
        }
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        BufferUtils.draw(buffer);
        RendererUtils.endRender();
    }

    public static void renderCircle(class_4587 matrices, Color circleColor, double originX, double originY, double rad, @Range(from=4L, to=360L) int segments) {
        Renderer2d.renderEllipse(matrices, circleColor, originX, originY, rad, rad, segments);
    }

    public static void renderEllipseOutline(class_4587 matrices, Color ellipseColor, double originX, double originY, double radX, double radY, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double width, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) double height, @Range(from=4L, to=360L) int segments) {
        segments = class_3532.method_15340((int)segments, (int)4, (int)360);
        width = class_3532.method_15350((double)width, (double)0.0, (double)radX);
        height = class_3532.method_15350((double)height, (double)0.0, (double)radY);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float[] colorFloat = Renderer3d.getColor(ellipseColor);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= segments; ++i) {
            double radians = Math.toRadians((double)((double)i / (double)segments * 360.0));
            double sin = Math.sin((double)radians) * (radX - width);
            double cos = Math.cos((double)radians) * (radY - height);
            double sin1 = Math.sin((double)radians) * radX;
            double cos1 = Math.cos((double)radians) * radY;
            buffer.method_22918(matrix, (float)(originX + sin), (float)(originY + cos), 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
            buffer.method_22918(matrix, (float)(originX + sin1), (float)(originY + cos1), 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        }
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        BufferUtils.draw(buffer);
        RendererUtils.endRender();
    }

    public static void renderQuad(class_4587 matrices, Color color, double x1, double y1, double x2, double y2) {
        double j;
        if (x1 < x2) {
            j = x1;
            x1 = x2;
            x2 = j;
        }
        if (y1 < y2) {
            j = y1;
            y1 = y2;
            y2 = j;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        float[] colorFloat = Renderer3d.getColor(color);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        BufferUtils.draw(buffer);
        RendererUtils.endRender();
    }

    private static void renderRoundedQuadInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, float fromX, float fromY, float toX, float toY, float radC1, float radC2, float radC3, float radC4, float samples) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Renderer2d._populateRC(toX - radC4, toY - radC4, radC4, 0);
        Renderer2d._populateRC(toX - radC2, fromY + radC2, radC2, 1);
        Renderer2d._populateRC(fromX + radC1, fromY + radC1, radC1, 2);
        Renderer2d._populateRC(fromX + radC3, toY - radC3, radC3, 3);
        for (int i = 0; i < 4; ++i) {
            float[] current = roundedCache[i];
            float rad = current[2];
            for (float r = (float)i * 90.0f; r <= (float)(i + 1) * 90.0f; r += 90.0f / samples) {
                float rad1 = Math.toRadians((float)r);
                float sin = Math.sin((float)rad1) * rad;
                float cos = Math.cos((float)rad1) * rad;
                bufferBuilder.method_22918(matrix, current[0] + sin, current[1] + cos, 0.0f).method_22915(cr, cg, cb, ca).method_1344();
            }
        }
        BufferUtils.draw(bufferBuilder);
    }

    public static void renderRoundedQuad(class_4587 matrices, Color c, double fromX, double fromY, double toX, double toY, float radTL, float radTR, float radBL, float radBR, float samples) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float[] color1 = Renderer3d.getColor(c);
        float r = color1[0];
        float g = color1[1];
        float b = color1[2];
        float a = color1[3];
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        Renderer2d.renderRoundedQuadInternal(matrix, r, g, b, a, (float)fromX, (float)fromY, (float)toX, (float)toY, radTL, radTR, radBL, radBR, samples);
        RendererUtils.endRender();
    }

    public static void renderRoundedQuad(class_4587 stack, Color c, double x, double y, double x1, double y1, float rad, float samples) {
        Renderer2d.renderRoundedQuad(stack, c, x, y, x1, y1, rad, rad, rad, rad, samples);
    }

    private static void _populateRC(float a, float b, float c, int i) {
        Renderer2d.roundedCache[i][0] = a;
        Renderer2d.roundedCache[i][1] = b;
        Renderer2d.roundedCache[i][2] = c;
    }

    private static void renderRoundedOutlineInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, float fromX, float fromY, float toX, float toY, float radC1, float radC2, float radC3, float radC4, float width, float samples) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        Renderer2d._populateRC(toX - radC4, toY - radC4, radC4, 0);
        Renderer2d._populateRC(toX - radC2, fromY + radC2, radC2, 1);
        Renderer2d._populateRC(fromX + radC1, fromY + radC1, radC1, 2);
        Renderer2d._populateRC(fromX + radC3, toY - radC3, radC3, 3);
        for (int i = 0; i < 4; ++i) {
            float[] current = roundedCache[i];
            float rad = current[2];
            for (float r = (float)i * 90.0f; r <= (float)(i + 1) * 90.0f; r += 90.0f / samples) {
                float rad1 = Math.toRadians((float)r);
                float sin1 = Math.sin((float)rad1);
                float sin = sin1 * rad;
                float cos1 = Math.cos((float)rad1);
                float cos = cos1 * rad;
                bufferBuilder.method_22918(matrix, current[0] + sin, current[1] + cos, 0.0f).method_22915(cr, cg, cb, ca).method_1344();
                bufferBuilder.method_22918(matrix, current[0] + sin + sin1 * width, current[1] + cos + cos1 * width, 0.0f).method_22915(cr, cg, cb, ca).method_1344();
            }
        }
        float[] current = roundedCache[0];
        float rad = current[2];
        bufferBuilder.method_22918(matrix, current[0], current[1] + rad, 0.0f).method_22915(cr, cg, cb, ca).method_1344();
        bufferBuilder.method_22918(matrix, current[0], current[1] + rad + width, 0.0f).method_22915(cr, cg, cb, ca).method_1344();
        BufferUtils.draw(bufferBuilder);
    }

    public static void renderRoundedOutline(class_4587 matrices, Color c, double fromX, double fromY, double toX, double toY, float radTL, float radTR, float radBL, float radBR, float outlineWidth, float samples) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float[] color1 = Renderer3d.getColor(c);
        float r = color1[0];
        float g = color1[1];
        float b = color1[2];
        float a = color1[3];
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        Renderer2d.renderRoundedOutlineInternal(matrix, r, g, b, a, (float)fromX, (float)fromY, (float)toX, (float)toY, radTL, radTR, radBL, radBR, outlineWidth, samples);
        RendererUtils.endRender();
    }

    public static void renderRoundedOutline(class_4587 matrices, Color c, double fromX, double fromY, double toX, double toY, float rad, float width, float samples) {
        Renderer2d.renderRoundedOutline(matrices, c, fromX, fromY, toX, toY, rad, rad, rad, rad, width, samples);
    }

    public static void renderLine(class_4587 stack, Color color, double x, double y, double x1, double y1) {
        float[] colorFloat = Colors.intArrayToFloatArray(Colors.ARGBIntToRGBA(color.getRGB()));
        Matrix4f m = stack.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        bufferBuilder.method_22918(m, (float)x, (float)y, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        bufferBuilder.method_22918(m, (float)x1, (float)y1, 0.0f).method_22915(colorFloat[0], colorFloat[1], colorFloat[2], colorFloat[3]).method_1344();
        RendererUtils.setupRender();
        RenderSystem.setShader(class_757::method_34540);
        BufferUtils.draw(bufferBuilder);
        RendererUtils.endRender();
    }
}

