/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import me.x150.renderer.mixinUtil.ShaderEffectDuck;
import me.x150.renderer.shader.ShaderManager;
import net.minecraft.class_276;
import net.minecraft.class_310;

public class OutlineFramebuffer
extends class_276 {
    private static OutlineFramebuffer instance;

    private OutlineFramebuffer(int width, int height) {
        super(false);
        RenderSystem.assertOnRenderThreadOrInit();
        this.method_1234(width, height, true);
        this.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private static OutlineFramebuffer obtain() {
        if (instance == null) {
            instance = new OutlineFramebuffer(class_310.method_1551().method_1522().field_1482, class_310.method_1551().method_1522().field_1481);
        }
        return instance;
    }

    public static void use(Runnable r) {
        class_276 mainBuffer = class_310.method_1551().method_1522();
        RenderSystem.assertOnRenderThreadOrInit();
        OutlineFramebuffer buffer = OutlineFramebuffer.obtain();
        if (buffer.field_1482 != mainBuffer.field_1482 || buffer.field_1481 != mainBuffer.field_1481) {
            buffer.method_1234(mainBuffer.field_1482, mainBuffer.field_1481, false);
        }
        GlStateManager._glBindFramebuffer((int)36009, (int)buffer.field_1476);
        buffer.method_1235(true);
        r.run();
        buffer.method_1240();
        GlStateManager._glBindFramebuffer((int)36009, (int)mainBuffer.field_1476);
        mainBuffer.method_1235(false);
    }

    public static void draw(float radius, Color outlineColor, Color innerColor) {
        class_276 mainBuffer = class_310.method_1551().method_1522();
        OutlineFramebuffer buffer = OutlineFramebuffer.obtain();
        ((ShaderEffectDuck)Objects.requireNonNull(ShaderManager.OUTLINE_SHADER.getShaderEffect())).renderer$addFakeTarget("inp", buffer);
        class_276 out = ShaderManager.OUTLINE_SHADER.getShaderEffect().method_1264("out");
        ShaderManager.OUTLINE_SHADER.setUniformValue("Radius", radius);
        ShaderManager.OUTLINE_SHADER.setUniformValue("OutlineColor", (float)outlineColor.getRed() / 255.0f, (float)outlineColor.getGreen() / 255.0f, (float)outlineColor.getBlue() / 255.0f, (float)outlineColor.getAlpha() / 255.0f);
        ShaderManager.OUTLINE_SHADER.setUniformValue("InnerColor", (float)innerColor.getRed() / 255.0f, (float)innerColor.getGreen() / 255.0f, (float)innerColor.getBlue() / 255.0f, (float)innerColor.getAlpha() / 255.0f);
        ShaderManager.OUTLINE_SHADER.setUniformValue("Radius", radius);
        ShaderManager.OUTLINE_SHADER.render(class_310.method_1551().method_1488());
        buffer.method_1230(false);
        mainBuffer.method_1235(false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.backupProjectionMatrix();
        out.method_22594(out.field_1482, out.field_1481, false);
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static void useAndDraw(Runnable r, float radius, Color outline, Color inner) {
        OutlineFramebuffer.use(r);
        OutlineFramebuffer.draw(radius, outline, inner);
    }
}

