/*
 * Decompiled with CFR 0.152.
 */
package me.x150.renderer.objfile;

import com.mojang.blaze3d.systems.RenderSystem;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjSplitting;
import de.javagl.obj.ObjUtils;
import de.javagl.obj.ReadableObj;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import me.x150.renderer.util.BufferUtils;
import me.x150.renderer.util.RendererUtils;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ObjFile
implements Closeable {
    private final ResourceProvider provider;
    private final String name;
    final Map<Obj, class_291> buffers = new HashMap<Obj, class_291>();
    final Map<String, class_2960> boundTextures = new HashMap<String, class_2960>();
    Map<String, Obj> materialNameObjMap;
    private List<Mtl> allMaterials;
    private boolean baked = false;
    private boolean closed = false;

    public ObjFile(String name, ResourceProvider provider) throws IOException {
        this.name = name;
        this.provider = provider;
        this.read();
    }

    private static class_243 transformVec3d(class_243 in) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        return in.method_1020(camPos);
    }

    private void read() throws IOException {
        try (InputStream reader = this.provider.open(this.name);){
            Obj r = ObjUtils.convertToRenderable((ReadableObj)ObjReader.read((InputStream)reader));
            this.allMaterials = new ArrayList<Mtl>();
            for (String mtlFileName : r.getMtlFileNames()) {
                InputStream openReaderTo = this.provider.open(mtlFileName);
                try {
                    List read = MtlReader.read((InputStream)openReaderTo);
                    this.allMaterials.addAll(read);
                }
                finally {
                    if (openReaderTo == null) continue;
                    openReaderTo.close();
                }
            }
            this.materialNameObjMap = ObjSplitting.splitByMaterialGroups((ReadableObj)r);
        }
    }

    private class_2960 createTex0(String s) {
        class_2960 class_29602;
        block8: {
            InputStream reader = this.provider.open(s);
            try {
                class_2960 identifier = RendererUtils.randomIdentifier();
                BufferedImage read1 = ImageIO.read(reader);
                RendererUtils.registerBufferedImageTexture(identifier, read1);
                class_29602 = identifier;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return class_29602;
    }

    private void bake() {
        class_287 b = class_289.method_1348().method_1349();
        for (Map.Entry<String, Obj> stringObjEntry : this.materialNameObjMap.entrySet()) {
            boolean hasTexture;
            String materialName = stringObjEntry.getKey();
            Obj objToDraw = stringObjEntry.getValue();
            Mtl material = this.allMaterials.stream().filter(f -> f.getName().equals(materialName)).findFirst().orElse(null);
            boolean bl = hasTexture = material != null && material.getMapKd() != null;
            if (hasTexture) {
                String mapKd = material.getMapKd();
                this.boundTextures.computeIfAbsent(mapKd, this::createTex0);
            }
            class_293 vmf = material != null ? (hasTexture ? class_290.field_1577 : class_290.field_1576) : class_290.field_1592;
            b.method_1328(class_293.class_5596.field_27379, vmf);
            for (int i = 0; i < objToDraw.getNumFaces(); ++i) {
                ObjFace face = objToDraw.getFace(i);
                boolean hasNormals = face.containsNormalIndices();
                boolean hasUV = face.containsTexCoordIndices();
                for (int i1 = 0; i1 < face.getNumVertices(); ++i1) {
                    FloatTuple xyz = objToDraw.getVertex(face.getVertexIndex(i1));
                    class_4588 vertex = b.method_22912((double)xyz.getX(), (double)xyz.getY(), (double)xyz.getZ());
                    if (vmf == class_290.field_1577) {
                        if (!hasUV) {
                            throw new IllegalStateException("Diffuse texture present, vertex doesn't have UV coordinates. File corrupted?");
                        }
                        if (!hasNormals) {
                            throw new IllegalStateException("Diffuse texture present, vertex doesn't have normal coordinates. File corrupted?");
                        }
                        FloatTuple uvs = objToDraw.getTexCoord(face.getTexCoordIndex(i1));
                        vertex.method_22913(uvs.getX(), 1.0f - uvs.getY());
                    }
                    if (vmf == class_290.field_1577 || vmf == class_290.field_1576) {
                        Objects.requireNonNull(material);
                        FloatTuple kd = material.getKd();
                        if (kd != null) {
                            vertex.method_22915(kd.getX(), kd.getY(), kd.getZ(), 1.0f);
                        } else {
                            vertex.method_22915(1.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    if (vmf == class_290.field_1577) {
                        FloatTuple normals = objToDraw.getNormal(face.getNormalIndex(i1));
                        vertex.method_22914(normals.getX(), normals.getY(), normals.getZ());
                    }
                    vertex.method_1344();
                }
            }
            class_287.class_7433 end = b.method_1326();
            this.buffers.put(objToDraw, BufferUtils.createVbo(end, class_291.class_8555.field_44793));
        }
        this.baked = true;
    }

    public void draw(class_4587 stack, Matrix4f viewMatrix, class_243 origin) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (!this.baked) {
            this.bake();
        }
        class_243 o = ObjFile.transformVec3d(origin);
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4f m4f = new Matrix4f((Matrix4fc)stack.method_23760().method_23761());
        m4f.translate((float)o.field_1352, (float)o.field_1351, (float)o.field_1350);
        m4f.mul((Matrix4fc)viewMatrix);
        RendererUtils.setupRender();
        RenderSystem.enableCull();
        for (Map.Entry<String, Obj> stringObjEntry : this.materialNameObjMap.entrySet()) {
            boolean hasTexture;
            String materialName = stringObjEntry.getKey();
            Obj obj = stringObjEntry.getValue();
            Mtl material = this.allMaterials.stream().filter(f -> f.getName().equals(materialName)).findFirst().orElse(null);
            boolean bl = hasTexture = material != null && material.getMapKd() != null;
            if (hasTexture) {
                String mapKd = material.getMapKd();
                class_2960 identifier = this.boundTextures.get(mapKd);
                RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            }
            Supplier<class_5944> shader = material != null ? (hasTexture ? class_757::method_34549 : class_757::method_34540) : class_757::method_34539;
            class_291 vertexBuffer = this.buffers.get(obj);
            vertexBuffer.method_1353();
            vertexBuffer.method_34427(m4f, projectionMatrix, shader.get());
        }
        class_291.method_1354();
        RendererUtils.endRender();
    }

    @Override
    public void close() {
        for (class_291 buffer : this.buffers.values()) {
            buffer.close();
        }
        this.buffers.clear();
        for (class_2960 value : this.boundTextures.values()) {
            class_310.method_1551().method_1531().method_4615(value);
        }
        this.boundTextures.clear();
        this.allMaterials.clear();
        this.closed = true;
    }

    @FunctionalInterface
    public static interface ResourceProvider {
        public static ResourceProvider ofPath(Path parent) {
            return name -> {
                Path resolve = parent.resolve(name);
                return Files.newInputStream(resolve, new OpenOption[0]);
            };
        }

        public InputStream open(String var1) throws IOException;
    }
}

