/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.data;

import com.google.gson.annotations.SerializedName;
import io.github.moulberry.repo.data.NEURecipe;
import io.github.moulberry.repo.util.NEUId;
import java.util.ArrayList;
import java.util.List;

public class NEUItem {
    @SerializedName(value="itemid")
    String minecraftItemId;
    @SerializedName(value="displayname")
    String displayName;
    String nbttag;
    int damage;
    List<String> lore;
    @SerializedName(value="internalname")
    @NEUId
    String skyblockItemId;
    String crafttext;
    String clickcommand;
    String modver;
    String infoType;
    List<String> info;
    boolean vanilla = false;
    @SerializedName(value="recipe")
    NEURecipe singletonRecipe = null;
    @SerializedName(value="recipes")
    List<NEURecipe> recipeList = new ArrayList<NEURecipe>();
    volatile transient List<NEURecipe> recipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NEURecipe> getRecipes() {
        if (this.recipes == null) {
            NEUItem nEUItem = this;
            synchronized (nEUItem) {
                if (this.recipes == null) {
                    ArrayList<NEURecipe> newRecipes = new ArrayList<NEURecipe>(this.recipeList.size() + (this.singletonRecipe == null ? 0 : 1));
                    newRecipes.addAll(this.recipeList);
                    if (this.singletonRecipe != null) {
                        newRecipes.add(this.singletonRecipe);
                    }
                    this.recipes = newRecipes;
                    for (NEURecipe recipe : this.recipes) {
                        recipe.fillItemInfo(this);
                    }
                }
            }
        }
        return this.recipes;
    }

    public String getMinecraftItemId() {
        return this.minecraftItemId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNbttag() {
        return this.nbttag;
    }

    public int getDamage() {
        return this.damage;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public String getSkyblockItemId() {
        return this.skyblockItemId;
    }

    public String getCrafttext() {
        return this.crafttext;
    }

    public String getClickcommand() {
        return this.clickcommand;
    }

    public String getModver() {
        return this.modver;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public List<String> getInfo() {
        return this.info;
    }

    public boolean isVanilla() {
        return this.vanilla;
    }

    private NEURecipe getSingletonRecipe() {
        return this.singletonRecipe;
    }

    private List<NEURecipe> getRecipeList() {
        return this.recipeList;
    }
}

