/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Parents {
    Map<String, List<String>> parents;
    Map<String, String> reverseParents = new HashMap<String, String>();

    public Parents(Map<String, List<String>> parents) {
        this.parents = parents;
        if (parents == null) {
            return;
        }
        for (Map.Entry<String, List<String>> parentings : parents.entrySet()) {
            String parent = parentings.getKey();
            for (String child : parentings.getValue()) {
                this.reverseParents.put(child, parent);
            }
        }
    }

    public List<String> getChildren(String itemId) {
        if (this.reverseParents == null) {
            return new ArrayList<String>();
        }
        return this.parents.getOrDefault(itemId, new ArrayList());
    }

    public Optional<String> getParent(String itemId) {
        if (this.reverseParents == null) {
            return Optional.empty();
        }
        return this.reverseParents.containsKey(itemId) ? Optional.of(this.reverseParents.get(itemId)) : Optional.empty();
    }

    public Map<String, List<String>> getParents() {
        return this.parents;
    }
}

