/*
 * Decompiled with CFR 0.152.
 */
package marcono1234.gson.recordadapter;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

class TreeTypeAdapter<T>
extends TypeAdapter<T> {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;
    private final Gson gson;
    private final TypeToken<T> type;
    private final TypeAdapter<JsonElement> jsonElementAdapter;
    private final GsonContext context;
    private volatile TypeAdapter<T> delegate;

    TreeTypeAdapter(JsonSerializer<T> serializer, JsonDeserializer<T> deserializer, Gson gson, TypeToken<T> type) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.gson = gson;
        this.type = type;
        this.jsonElementAdapter = gson.getAdapter(JsonElement.class);
        this.context = new GsonContext(gson);
    }

    private TypeAdapter<T> delegate() {
        TypeAdapter delegate = this.delegate;
        if (delegate == null) {
            this.delegate = delegate = this.gson.getAdapter(this.type);
        }
        return delegate;
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (this.serializer == null) {
            this.delegate().write(out, value);
        } else {
            JsonElement jsonElement = this.serializer.serialize(value, this.type.getType(), (JsonSerializationContext)this.context);
            this.jsonElementAdapter.write(out, (Object)jsonElement);
        }
    }

    public T read(JsonReader in) throws IOException {
        if (this.deserializer == null) {
            return (T)this.delegate().read(in);
        }
        JsonElement jsonElement = (JsonElement)this.jsonElementAdapter.read(in);
        return (T)this.deserializer.deserialize(jsonElement, this.type.getType(), (JsonDeserializationContext)this.context);
    }

    private static class GsonContext
    implements JsonSerializationContext,
    JsonDeserializationContext {
        private final Gson gson;

        private GsonContext(Gson gson) {
            this.gson = gson;
        }

        public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            return (T)this.gson.fromJson(json, typeOfT);
        }

        public JsonElement serialize(Object src) {
            return this.gson.toJsonTree(src);
        }

        public JsonElement serialize(Object src, Type typeOfSrc) {
            return this.gson.toJsonTree(src, typeOfSrc);
        }
    }
}

