/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

public class GlobalizedClothConfigScreen
extends AbstractConfigScreen
implements ReferenceBuildingConfigScreen,
Expandable {
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private class_339 cancelButton;
    private class_339 exitButton;
    private final LinkedHashMap<class_2561, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final ScrollingContainer sideScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(4, 4, GlobalizedClothConfigScreen.this.getSideSliderPosition() - 14 - 4, GlobalizedClothConfigScreen.this.field_22790 - 8);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Reference reference : GlobalizedClothConfigScreen.this.references) {
                if (i != 0) {
                    i = (int)((float)i + 3.0f * reference.getScale());
                }
                float f = i;
                GlobalizedClothConfigScreen.this.field_22793.getClass();
                i = (int)(f + 9.0f * reference.getScale());
            }
            return i;
        }
    };
    private Reference lastHoveredReference = null;
    private final ScrollingContainer sideSlider = new ScrollingContainer(){
        private Rectangle empty = new Rectangle();

        @Override
        public Rectangle getBounds() {
            return this.empty;
        }

        @Override
        public int getMaxScrollHeight() {
            return 1;
        }
    };
    private final List<Reference> references = Lists.newArrayList();
    private final LazyResettable<Integer> sideExpandLimit = new LazyResettable<Integer>(() -> {
        int max = 0;
        for (Reference reference : this.references) {
            class_2561 referenceText = reference.getText();
            int width = this.field_22793.method_27525((class_5348)new class_2585(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ").method_10852(referenceText));
            if (width <= max) continue;
            max = width;
        }
        return Math.min(max + 8, this.field_22789 / 4);
    });
    private boolean requestingReferenceRebuilding = false;

    @ApiStatus.Internal
    public GlobalizedClothConfigScreen(class_437 parent, class_2561 title, Map<class_2561, ConfigCategory> categoryMap, class_2960 backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof class_3545 ? (AbstractConfigListEntry)((class_3545)object).method_15441() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put((class_2561)categoryName, entries);
        });
        this.sideSlider.scrollTo(0.0, false);
    }

    @Override
    public void requestReferenceRebuilding() {
        this.requestingReferenceRebuilding = true;
    }

    @Override
    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void method_25426() {
        super.method_25426();
        this.sideExpandLimit.reset();
        this.references.clear();
        this.buildReferences();
        this.listWidget = new ClothConfigScreen.ListWidget(this, this.field_22787, this.field_22789 - 14, this.field_22790, 30, this.field_22790 - 32, this.getBackgroundLocation());
        this.field_22786.add(this.listWidget);
        this.listWidget.setLeftPos(14);
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.method_25396().isEmpty()) {
                this.listWidget.method_25396().add(new EmptyEntry(5));
            }
            this.listWidget.method_25396().add(new EmptyEntry(4));
            this.listWidget.method_25396().add(new CategoryTextEntry((class_2561)category, (class_2561)category.method_27661().method_27692(class_124.field_1067)));
            this.listWidget.method_25396().add(new EmptyEntry(4));
            this.listWidget.method_25396().addAll(entries);
        });
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 3);
        this.cancelButton = new class_4185(0, this.field_22790 - 26, buttonWidths, 20, (class_2561)(this.isEdited() ? new class_2588("text.cloth-config.cancel_discard") : new class_2588("gui.cancel")), widget -> this.quit());
        this.method_25411(this.cancelButton);
        this.exitButton = new class_4185(0, this.field_22790 - 26, buttonWidths, 20, class_333.field_18967, button -> this.saveAll(true)){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List entries : GlobalizedClothConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.field_22763 = GlobalizedClothConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? new class_2588("text.cloth-config.error_cannot_save") : new class_2588("text.cloth-config.save_and_done")));
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        this.method_25411(this.exitButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    private void buildReferences() {
        this.categorizedEntries.forEach((categoryText, entries) -> {
            this.references.add(new CategoryReference((class_2561)categoryText));
            for (AbstractConfigEntry entry : entries) {
                this.buildReferenceFor(entry, 1);
            }
        });
    }

    private void buildReferenceFor(AbstractConfigEntry<?> entry, int layer) {
        List<ReferenceProvider<?>> referencableEntries = entry.getReferenceProviderEntries();
        if (referencableEntries != null) {
            this.references.add(new ConfigEntryReference(entry, layer));
            for (ReferenceProvider<?> referencableEntry : referencableEntries) {
                this.buildReferenceFor(referencableEntry.provideReferenceEntry(), layer + 1);
            }
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.lastHoveredReference = null;
        if (this.requestingReferenceRebuilding) {
            this.references.clear();
            this.buildReferences();
            this.requestingReferenceRebuilding = false;
        }
        int sliderPosition = this.getSideSliderPosition();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(sliderPosition, 0, this.field_22789 - sliderPosition, this.field_22790));
        if (this.isTransparentBackground()) {
            this.method_25296(matrices, 14, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        } else {
            this.method_25434(0);
            this.overlayBackground(matrices, new Rectangle(14, 0, this.field_22789, this.field_22790), 64, 64, 64, 255, 255);
        }
        this.listWidget.width = this.field_22789 - sliderPosition;
        this.listWidget.setLeftPos(sliderPosition);
        this.listWidget.method_25394(matrices, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry child : this.listWidget.method_25396()) {
            child.lateRender(matrices, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.field_22793.method_27517(matrices, this.field_22785.method_30937(), (float)sliderPosition + (float)(this.field_22789 - sliderPosition) / 2.0f - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f, 12.0f, -1);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.cancelButton.field_22760 = sliderPosition + (this.field_22789 - sliderPosition) / 2 - this.cancelButton.method_25368() - 3;
        this.exitButton.field_22760 = sliderPosition + (this.field_22789 - sliderPosition) / 2 + 3;
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.sideSlider.updatePosition(delta);
        this.sideScroller.updatePosition(delta);
        if (this.isTransparentBackground()) {
            this.method_25296(matrices, 0, 0, sliderPosition, this.field_22790, -1240461296, -972025840);
            this.method_25296(matrices, 0, 0, sliderPosition - 14, this.field_22790, 0x68000000, 0x68000000);
        } else {
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            this.field_22787.method_1531().method_22813(this.getBackgroundLocation());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            buffer.method_1328(7, class_290.field_1575);
            buffer.method_22912((double)(sliderPosition - 14), (double)this.field_22790, 0.0).method_22913(0.0f, (float)this.field_22790 / 32.0f).method_1336(68, 68, 68, 255).method_1344();
            buffer.method_22912((double)sliderPosition, (double)this.field_22790, 0.0).method_22913(0.4375f, (float)this.field_22790 / 32.0f).method_1336(68, 68, 68, 255).method_1344();
            buffer.method_22912((double)sliderPosition, 0.0, 0.0).method_22913(0.4375f, 0.0f).method_1336(68, 68, 68, 255).method_1344();
            buffer.method_22912((double)(sliderPosition - 14), 0.0, 0.0).method_22913(0.0f, 0.0f).method_1336(68, 68, 68, 255).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1575);
            buffer.method_22912(0.0, (double)this.field_22790, 0.0).method_22913(0.0f, (float)(this.field_22790 + (int)this.sideScroller.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            buffer.method_22912((double)(sliderPosition - 14), (double)this.field_22790, 0.0).method_22913((float)(sliderPosition - 14) / 32.0f, (float)(this.field_22790 + (int)this.sideScroller.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            buffer.method_22912((double)(sliderPosition - 14), 0.0, 0.0).method_22913((float)(sliderPosition - 14) / 32.0f, (float)((int)this.sideScroller.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            buffer.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, (float)((int)this.sideScroller.scrollAmount) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tessellator.method_1350();
        }
        class_1159 matrix = matrices.method_23760().method_23761();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int shadeColor = this.isTransparentBackground() ? 120 : 160;
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22918(matrix, (float)(sliderPosition + 4), 0.0f, 100.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(matrix, (float)sliderPosition, 0.0f, 100.0f).method_1336(0, 0, 0, shadeColor).method_1344();
        buffer.method_22918(matrix, (float)sliderPosition, (float)this.field_22790, 100.0f).method_1336(0, 0, 0, shadeColor).method_1344();
        buffer.method_22918(matrix, (float)(sliderPosition + 4), (float)this.field_22790, 100.0f).method_1336(0, 0, 0, 0).method_1344();
        tessellator.method_1350();
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22918(matrix, (float)(sliderPosition - 14), 0.0f, 100.0f).method_1336(0, 0, 0, shadeColor /= 2).method_1344();
        buffer.method_22918(matrix, (float)(sliderPosition - 14 - 4), 0.0f, 100.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(matrix, (float)(sliderPosition - 14 - 4), (float)this.field_22790, 100.0f).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22918(matrix, (float)(sliderPosition - 14), (float)this.field_22790, 100.0f).method_1336(0, 0, 0, shadeColor).method_1344();
        tessellator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        Rectangle slideArrowBounds = new Rectangle(sliderPosition - 14, 0, 14, this.field_22790);
        RenderSystem.enableAlphaTest();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        this.field_22793.method_1724(">", (float)(sliderPosition - 7) - (float)this.field_22793.method_1727(">") / 2.0f, (float)(this.field_22790 / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | class_3532.method_15340((int)class_3532.method_15384((double)((1.0 - this.sideSlider.scrollAmount) * 255.0)), (int)0, (int)255) << 24, false, matrices.method_23760().method_23761(), (class_4597)immediate, false, 0, 0xF000F0);
        this.field_22793.method_1724("<", (float)(sliderPosition - 7) - (float)this.field_22793.method_1727("<") / 2.0f, (float)(this.field_22790 / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | class_3532.method_15340((int)class_3532.method_15384((double)(this.sideSlider.scrollAmount * 255.0)), (int)0, (int)255) << 24, false, matrices.method_23760().method_23761(), (class_4597)immediate, false, 0, 0xF000F0);
        immediate.method_22993();
        Rectangle scrollerBounds = this.sideScroller.getBounds();
        if (!scrollerBounds.isEmpty()) {
            ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 0, sliderPosition - 14, this.field_22790));
            int scrollOffset = (int)((double)scrollerBounds.y - this.sideScroller.scrollAmount);
            for (Reference reference : this.references) {
                matrices.method_22903();
                matrices.method_22905(reference.getScale(), reference.getScale(), reference.getScale());
                class_5250 text = new class_2585(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ").method_10852(reference.getText());
                if (this.lastHoveredReference == null) {
                    int n = scrollerBounds.x;
                    int n2 = (int)((float)scrollOffset - 4.0f * reference.getScale());
                    int n3 = (int)((float)this.field_22793.method_27525((class_5348)text) * reference.getScale());
                    this.field_22793.getClass();
                    if (new Rectangle(n, n2, n3, (int)((float)(9 + 4) * reference.getScale())).contains(mouseX, mouseY)) {
                        this.lastHoveredReference = reference;
                    }
                }
                this.field_22793.method_27528(matrices, text.method_30937(), (float)scrollerBounds.x, (float)scrollOffset, this.lastHoveredReference == reference ? 16769544 : 0xFFFFFF);
                matrices.method_22909();
                float f = scrollOffset;
                this.field_22793.getClass();
                scrollOffset = (int)(f + (float)(9 + 3) * reference.getScale());
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.sideScroller.renderScrollBar();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.field_22790);
        if (button == 0 && slideBounds.contains(mouseX, mouseY) && this.lastHoveredReference != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            this.lastHoveredReference.go();
            return true;
        }
        Rectangle slideArrowBounds = new Rectangle(this.getSideSliderPosition() - 14, 0, 14, this.field_22790);
        if (button == 0 && slideArrowBounds.contains(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean isExpanded() {
        return this.sideSlider.scrollTarget == 1.0;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.sideSlider.scrollTo(expanded ? 1.0 : 0.0, true, 2000L);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.field_22790);
        if (slideBounds.contains(mouseX, mouseY)) {
            this.sideScroller.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private int getSideSliderPosition() {
        return (int)(this.sideSlider.scrollAmount * (double)this.sideExpandLimit.get().intValue() + 14.0);
    }

    private class ConfigEntryReference
    implements Reference {
        private AbstractConfigEntry<?> entry;
        private int layer;

        public ConfigEntryReference(AbstractConfigEntry<?> entry, int layer) {
            this.entry = entry;
            this.layer = layer;
        }

        @Override
        public int getIndent() {
            return this.layer;
        }

        @Override
        public class_2561 getText() {
            return this.entry.getFieldName();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int[] i = new int[]{0};
            for (AbstractConfigEntry child : GlobalizedClothConfigScreen.this.listWidget.method_25396()) {
                int i1 = i[0];
                if (this.goChild(i, null, child)) {
                    return;
                }
                i[0] = i1 + child.getItemHeight();
            }
        }

        private boolean goChild(int[] i, Integer expandedParent, AbstractConfigEntry<?> root) {
            boolean expanded;
            if (root == this.entry) {
                GlobalizedClothConfigScreen.this.listWidget.scrollTo(expandedParent == null ? (double)i[0] : (double)expandedParent.intValue(), true);
                return true;
            }
            int j = i[0];
            i[0] = i[0] + root.getInitialReferenceOffset();
            boolean bl = expanded = root instanceof Expandable && ((Expandable)((Object)root)).isExpanded();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(true);
            }
            List children = root.method_25396();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(expanded);
            }
            for (class_364 child : children) {
                if (!(child instanceof ReferenceProvider)) continue;
                int i1 = i[0];
                if (this.goChild(i, expandedParent != null ? expandedParent : (root instanceof Expandable && !expanded ? Integer.valueOf(j) : null), ((ReferenceProvider)child).provideReferenceEntry())) {
                    return true;
                }
                i[0] = i1 + ((ReferenceProvider)child).provideReferenceEntry().getItemHeight();
            }
            return false;
        }
    }

    private class CategoryReference
    implements Reference {
        private class_2561 category;

        public CategoryReference(class_2561 category) {
            this.category = category;
        }

        @Override
        public class_2561 getText() {
            return this.category;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int i = 0;
            for (AbstractConfigEntry child : GlobalizedClothConfigScreen.this.listWidget.method_25396()) {
                if (child instanceof CategoryTextEntry && ((CategoryTextEntry)child).category == this.category) {
                    GlobalizedClothConfigScreen.this.listWidget.scrollTo(i, true);
                    return;
                }
                i += child.getItemHeight();
            }
        }
    }

    private static interface Reference {
        default public int getIndent() {
            return 0;
        }

        public class_2561 getText();

        public float getScale();

        public void go();
    }

    private static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final class_2561 category;
        private final class_2561 text;

        public CategoryTextEntry(class_2561 category, class_2561 text) {
            super((class_2561)new class_2585(UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        @Override
        public int getItemHeight() {
            List strings = class_310.method_1551().field_1772.method_1728((class_5348)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public void save() {
        }

        @Override
        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = class_310.method_1551().field_1772.method_1728((class_5348)this.text, this.getParent().getItemWidth());
            for (class_5481 text : texts) {
                class_310.method_1551().field_1772.method_27517(matrices, text, (float)(x - 4 + entryWidth / 2 - class_310.method_1551().field_1772.method_30880(text) / 2), (float)yy, -1);
                yy += 10;
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }

    private static class EmptyEntry
    extends AbstractConfigListEntry<Object> {
        private final int height;

        public EmptyEntry(int height) {
            super((class_2561)new class_2585(UUID.randomUUID().toString()), false);
            this.height = height;
        }

        @Override
        public int getItemHeight() {
            return this.height;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        @Override
        public void save() {
        }

        @Override
        public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
}

