/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.block.entity.ModBlockEntities;
import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.networking.ModMessages;
import com.kaboomroads.sculkybits.networking.packet.ClientboundSculkTriggerLengthPacket;
import com.kaboomroads.sculkybits.util.MathUtils;
import com.kaboomroads.sculkybits.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkFeelerBlockEntity
extends BlockEntity
implements SculkAttacker {
    public static final VoxelShape ATTACK_SHAPE = Block.m_49796_((double)4.0, (double)-64.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public LivingEntity entity = null;
    public float length = 0.0f;
    public float maxLength = 5.0f;
    public int cooldownTicks = 0;
    public int maxCooldown = 100;

    public SculkFeelerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_FEELER.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkFeelerBlockEntity blockEntity) {
        boolean onCooldown;
        if (level.f_46443_) {
            return;
        }
        boolean bl = onCooldown = blockEntity.cooldownTicks > 0;
        if (!onCooldown) {
            List<LivingEntity> entities = SculkAttacker.getAttackEntities(level, blockEntity);
            LivingEntity livingEntity = null;
            for (LivingEntity entity : entities) {
                if (!Utils.entityIsDamageable((Entity)entity) || !SculkAttacker.testAttackable((Entity)entity)) continue;
                livingEntity = entity;
                break;
            }
            if (livingEntity != null) {
                blockEntity.entity = livingEntity;
            }
        } else {
            --blockEntity.cooldownTicks;
        }
        if (blockEntity.entity != null) {
            if (onCooldown) {
                blockEntity.entity = null;
            } else if (blockEntity.length >= blockEntity.maxLength) {
                v = blockEntity.entity.m_20184_();
                blockEntity.entity.m_20334_(v.f_82479_, v.f_82480_ + 0.25, v.f_82481_);
                SculkAttacker.sculkDamage(blockEntity.entity);
                blockEntity.cooldownTicks = blockEntity.maxCooldown;
                blockEntity.entity = null;
            } else {
                v = blockEntity.entity.m_20184_();
                blockEntity.entity.m_20334_(v.f_82479_ * 0.1, v.f_82480_ + 0.1, v.f_82481_ * 0.1);
                blockEntity.entity.f_19864_ = true;
            }
        }
        blockEntity.length = blockEntity.entity != null ? MathUtils.interpolateLinear(blockEntity.length, blockEntity.maxLength, 0.25f) : MathUtils.interpolateLinear(blockEntity.length, 0.0f, 0.1f);
        Level level2 = blockEntity.f_58857_;
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                ModMessages.sendToClient(new ClientboundSculkTriggerLengthPacket(blockPos, blockEntity.length), player);
            }
        }
    }

    @Override
    public VoxelShape getAttackShape() {
        return ATTACK_SHAPE;
    }

    @Override
    public double getLevelX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }
}

