/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.effect.ModEffects;
import com.kaboomroads.sculkybits.entity.ModEntityTypes;
import com.kaboomroads.sculkybits.util.ModDamageSource;
import com.kaboomroads.sculkybits.util.Utils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SculkAttacker {
    public static final VoxelShape ATTACK_SHAPE_DEFAULT = Block.m_49796_((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0);
    public static final Predicate<Entity> ATTACKABLE_PREDICATE = e -> e.m_6095_() != EntityType.f_217015_ && e.m_6095_() != ModEntityTypes.SCULK_SAPROPHYTE.get();

    public static List<LivingEntity> getAttackEntities(Level p_155590_, SculkAttacker p_155591_) {
        return p_155591_.getAttackShape().m_83299_().stream().flatMap(p_155558_ -> p_155590_.m_6443_(LivingEntity.class, p_155558_.m_82386_(p_155591_.getLevelX() - 0.5, p_155591_.getLevelY() - 0.5, p_155591_.getLevelZ() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    public static void sculkDamage(LivingEntity livingEntity) {
        if (livingEntity.m_6095_() == EntityType.f_20532_) {
            livingEntity.f_19802_ = 0;
        }
        livingEntity.m_6469_(ModDamageSource.SCULK_ATTACK, 10.0f);
        if (!livingEntity.m_21023_((MobEffect)ModEffects.SCULK.get())) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SCULK.get(), 200, 0));
        } else {
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)ModEffects.SCULK.get());
            int duration = mobEffectInstance.m_19557_() - 40;
            int amplifier = mobEffectInstance.m_19564_() + 1;
            if (duration < 1) {
                duration = 1;
            }
            if (amplifier > 2) {
                amplifier = 2;
            }
            livingEntity.m_21195_((MobEffect)ModEffects.SCULK.get());
            Utils.addEffect(livingEntity, null, new MobEffectInstance((MobEffect)ModEffects.SCULK.get(), duration, amplifier), false, true);
        }
    }

    default public VoxelShape getAttackShape() {
        return ATTACK_SHAPE_DEFAULT;
    }

    public static boolean testAttackable(Entity entity) {
        return ATTACKABLE_PREDICATE.test(entity);
    }

    public double getLevelX();

    public double getLevelY();

    public double getLevelZ();
}

