/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.custom;

import com.kaboomroads.sculkybits.block.ModBlocks;
import com.kaboomroads.sculkybits.entity.ModEntityTypes;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SculkCageBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape COLLISION_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)26.0, (double)15.0), Block.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)24.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)24.0, (double)1.0), Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)24.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SculkCageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)context).m_193113_()) != null && entity.m_6095_() == ModEntityTypes.SCULK_SAPROPHYTE.get()) {
            return Shapes.m_83040_();
        }
        return COLLISION_SHAPE;
    }

    public boolean tryExtendCage(@NotNull Level level, @NotNull BlockPos pos) {
        if (level.f_46443_) {
            return false;
        }
        BlockPos placementPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        if (SculkCageBlock.checkCagePlacement(level.m_8055_(placementPos))) {
            if (level.m_8055_(placementPos).m_60767_() == Material.f_76305_) {
                level.m_7731_(placementPos, (BlockState)((Block)ModBlocks.SCULK_CAGE.get()).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            } else {
                level.m_7731_(placementPos, ((Block)ModBlocks.SCULK_CAGE.get()).m_49966_(), 2);
            }
            return true;
        }
        return false;
    }

    public void m_213897_(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if (level.f_46443_) {
            return;
        }
        this.tryExtendCage((Level)level, pos);
        super.m_213897_(blockState, level, pos, source);
    }

    public static boolean checkCagePlacement(@NotNull BlockState blockState) {
        return blockState.m_60713_(Blocks.f_220856_) || blockState.m_60795_() || blockState.m_60767_().m_76336_() || blockState.m_60767_() == Material.f_76305_;
    }

    public BlockState m_7417_(BlockState p_222204_, Direction p_222205_, BlockState p_222206_, LevelAccessor p_222207_, BlockPos p_222208_, BlockPos p_222209_) {
        if (((Boolean)p_222204_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_222207_.m_186469_(p_222208_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_222207_));
        }
        return super.m_7417_(p_222204_, p_222205_, p_222206_, p_222207_, p_222208_, p_222209_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_222171_) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(p_222171_.m_43725_().m_6425_(p_222171_.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState p_222230_) {
        return (Boolean)p_222230_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_222230_);
    }
}

