/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block;

import com.kaboomroads.sculkybits.block.custom.SculkAbsorberBlock;
import com.kaboomroads.sculkybits.block.custom.SculkBonesBlock;
import com.kaboomroads.sculkybits.block.custom.SculkCageBlock;
import com.kaboomroads.sculkybits.block.custom.SculkFeelerBlock;
import com.kaboomroads.sculkybits.block.custom.SculkGrowthBlock;
import com.kaboomroads.sculkybits.block.custom.SculkJawBlock;
import com.kaboomroads.sculkybits.block.custom.SculkLurerBlock;
import com.kaboomroads.sculkybits.block.custom.SculkLurkerBlock;
import com.kaboomroads.sculkybits.block.custom.SculkRibsBlock;
import com.kaboomroads.sculkybits.block.custom.SculkRotatedPillarBlock;
import com.kaboomroads.sculkybits.block.custom.SculkStabberBlock;
import com.kaboomroads.sculkybits.block.custom.SculkTrapBlock;
import com.kaboomroads.sculkybits.block.custom.override.ModSculkVeinBlock;
import com.kaboomroads.sculkybits.block.custom.override.SpreadingSculkBlock;
import com.kaboomroads.sculkybits.item.ModCreativeTabs;
import com.kaboomroads.sculkybits.item.ModItems;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS_OVERRIDE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sculkybits");
    public static final RegistryObject<Block> SPREADING_SCULK = ModBlocks.overrideBlockAndItem("sculk", () -> new SpreadingSculkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> SCULK_VEIN = ModBlocks.overrideBlockAndItem("sculk_vein", () -> new ModSculkVeinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220856_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> SCULK_FLESH = ModBlocks.registerBlockAndItem("sculk_flesh", () -> new SpreadingSculkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_GROWTH = ModBlocks.registerBlockAndItem("sculk_growth", () -> new SculkGrowthBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60956_(0.2f).m_60922_(Blocks::m_50809_).m_60924_(Blocks::m_50774_).m_60971_(Blocks::m_50774_).m_60960_(Blocks::m_50774_)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_JAW = ModBlocks.registerBlockAndItem("sculk_jaw", () -> new SculkJawBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_TRAP = ModBlocks.registerBlockAndItem("sculk_trap", () -> new SculkTrapBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_LURKER = ModBlocks.registerBlockAndItem("sculk_lurker", () -> new SculkLurkerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_STABBER = ModBlocks.registerBlockAndItem("sculk_stabber", () -> new SculkStabberBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_ABSORBER = ModBlocks.registerBlockAndItem("sculk_absorber", () -> new SculkAbsorberBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_LURER = ModBlocks.registerBlockAndItem("sculk_lurer", () -> new SculkLurerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_FEELER = ModBlocks.registerBlockAndItem("sculk_feeler", () -> new SculkFeelerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220855_).m_60913_(5.0f, 5.0f).m_60955_().m_60910_().m_60953_(b -> 5)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_CAGE = ModBlocks.registerBlockAndItem("sculk_cage", () -> new SculkCageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_222472_).m_60955_()), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_BONE_BLOCK = ModBlocks.registerBlockAndItem("sculk_bone_block", () -> new SculkRotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60913_(6.0f, 6.0f).m_60918_(SoundType.f_222472_)), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_RIBS = ModBlocks.registerBlockAndItem("sculk_ribs", () -> new SculkRibsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_222472_).m_60955_()), ModCreativeTabs.SCULKYBITS_TAB);
    public static final RegistryObject<Block> SCULK_BONES = ModBlocks.registerBlockAndItem("sculk_bones", () -> new SculkBonesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_222472_).m_60955_()), ModCreativeTabs.SCULKYBITS_TAB);
    public static final Predicate<BlockState> REQUIRES_ECHO_SHARD = blockState -> blockState.m_60713_((Block)SCULK_JAW.get()) || blockState.m_60713_((Block)SCULK_TRAP.get()) || blockState.m_60713_((Block)SCULK_LURKER.get()) || blockState.m_60713_((Block)SCULK_STABBER.get()) || blockState.m_60713_((Block)SCULK_ABSORBER.get()) || blockState.m_60713_((Block)SCULK_LURER.get());

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static <T extends Block> RegistryObject<T> registerBlockAndItem(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    public static <T extends Block> RegistryObject<T> overrideBlockAndItem(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS_OVERRIDE.register(name, block);
        ModBlocks.overrideBlockItem(name, toReturn, tab);
        return toReturn;
    }

    public static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return ModItems.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static <T extends Block> RegistryObject<Item> overrideBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return ModItems.overrideItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static <T extends Block> RegistryObject<Item> registerBlockItem(String name, BlockItem item) {
        return ModItems.registerItem(name, () -> item);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        BLOCKS_OVERRIDE.register(eventBus);
    }
}

