/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.fluid;

import com.kaboomroads.sculkybits.effect.ModEffects;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ModFluidTypes {
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"sculkybits");
    public static final RegistryObject<FluidType> SCULK_TYPE = FLUID_TYPES.register("sculk_fluid", () -> new FluidType(FluidType.Properties.create().descriptionId("fluid.sculkybits.sculk_fluid").canSwim(false).canDrown(false).adjacentPathType(null).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(1).density(13000).viscosity(5000).temperature(300).fallDistanceModifier(0.75f).supportsBoating(true).motionScale(0.01)){

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            double multiplier = 0.25;
            if (entity.f_19789_ >= 3.0f) {
                entity.m_142535_(entity.f_19789_, this.getFallDistanceModifier((Entity)entity), entity.m_9236_().m_269111_().m_268989_());
                entity.m_183634_();
            }
            Vec3 vec3 = entity.m_20184_().m_82542_(multiplier, entity.m_20184_().f_82480_ > 0.0 ? multiplier : multiplier * 2.0, multiplier);
            entity.m_20334_(vec3.f_82479_, entity.m_20096_() ? 0.0 : vec3.f_82480_ - 0.005, vec3.f_82481_);
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SCULK.get(), 200, 0));
            return super.move(state, entity, movementVector, gravity);
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation SCULK_STILL = new ResourceLocation("sculkybits", "block/sculk_fluid_still");
                private static final ResourceLocation SCULK_FLOW = new ResourceLocation("sculkybits", "block/sculk_fluid_flow");

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.0f, 0.1f, 0.125f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)0.1f);
                    RenderSystem.setShaderFogEnd((float)0.1f);
                    RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                }

                public ResourceLocation getStillTexture() {
                    return SCULK_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return SCULK_FLOW;
                }
            });
        }
    });

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

