/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.entity.custom;

import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.damagesource.ModDamageSources;
import com.kaboomroads.sculkybits.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SculkCrawler
extends Spider {
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();

    public SculkCrawler(EntityType<? extends Spider> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    public boolean isMovingOnLand() {
        return this.m_20096_() && this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20072_();
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 0.4f;
    }

    protected int m_5639_(float p_218519_, float p_218520_) {
        return super.m_5639_(p_218519_, p_218520_) - 5;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.isMovingOnLand()) {
                this.walkAnimationState.m_216982_(this.f_19797_);
            } else {
                this.walkAnimationState.m_216973_();
            }
        }
        super.m_8119_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new Spider.SpiderAttackGoal((Spider)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_7327_(@NotNull Entity entity) {
        int i;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        entity.f_19802_ = 0;
        boolean flag = entity.m_6469_(((ModDamageSources)this.m_9236_().m_269111_()).sculkEntityAttack((Entity)this), f);
        if (flag) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                SculkAttacker.applySculk(livingEntity);
                if (f1 > 0.0f) {
                    livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Utils.maybeDisableShield((Mob)this, player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return flag;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        this.m_216990_(SoundEvents.f_215757_);
    }

    public boolean m_213854_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_215753_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_215740_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215746_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomsource = levelAccessor.m_213780_();
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", randomsource.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        this.m_21559_(randomsource.m_188501_() < 0.05f);
        return spawnGroupData;
    }
}

