/*
 * Decompiled with CFR 0.152.
 */
package com.kaboomroads.sculkybits.block.entity.custom;

import com.kaboomroads.sculkybits.block.custom.SculkNestBlock;
import com.kaboomroads.sculkybits.block.entity.ModBlockEntities;
import com.kaboomroads.sculkybits.block.entity.custom.SculkAttacker;
import com.kaboomroads.sculkybits.entity.ModEntityTypes;
import com.kaboomroads.sculkybits.entity.custom.SculkCrawler;
import com.kaboomroads.sculkybits.gamerule.ModGameRules;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SculkNestBlockEntity
extends BlockEntity
implements GameEventListener.Holder<VibrationSystem.Listener>,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    private final VibrationSystem.User vibrationUser = this.createVibrationUser();

    public VibrationSystem.User createVibrationUser() {
        return new VibrationUser(this.m_58899_());
    }

    public static VoxelShape getRadius(float radius) {
        return Block.m_49796_((double)(-radius * 16.0f), (double)(-radius * 16.0f), (double)(-radius * 16.0f), (double)(radius * 16.0f), (double)(radius * 16.0f), (double)(radius * 16.0f));
    }

    public SculkNestBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_NEST.get(), pos, blockState);
    }

    public void trySpawn(Level level, @Nullable ServerPlayer player) {
        BlockPos pos = this.m_58899_();
        if (player == null || ((Boolean)this.m_58900_().m_61143_((Property)SculkNestBlock.INACTIVE)).booleanValue()) {
            return;
        }
        SculkCrawler crawler = (SculkCrawler)((EntityType)ModEntityTypes.SCULK_CRAWLER.get()).m_20615_(level);
        if (crawler == null) {
            return;
        }
        int i = 0;
        VoxelShape spiderRadius = SculkNestBlockEntity.getRadius(ModGameRules.RULE_SCULK_NEST_RANGE != null ? ((ModGameRules.FloatValue)level.m_46469_().m_46170_(ModGameRules.RULE_SCULK_NEST_RANGE)).get() : 10.0f);
        int amount = ModGameRules.RULE_SCULK_NEST_LIMIT != null ? ((GameRules.IntegerValue)level.m_46469_().m_46170_(ModGameRules.RULE_SCULK_NEST_LIMIT)).m_46288_() : 3;
        for (LivingEntity entity : SculkAttacker.getAttackEntities(level, spiderRadius, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) {
            if (entity.m_6095_() != ModEntityTypes.SCULK_CRAWLER.get() || ++i < amount) continue;
            return;
        }
        level.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkNestBlock.INACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        level.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 200);
        crawler.m_146884_(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
        level.m_7967_((Entity)crawler);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("listener", 10)) {
            VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222820_ -> tag.m_128365_("listener", p_222820_));
    }

    @NotNull
    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    @NotNull
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    protected class VibrationUser
    implements VibrationSystem.User {
        protected final BlockPos blockPos;
        private final PositionSource positionSource;

        public VibrationUser(BlockPos blockPos) {
            this.blockPos = blockPos;
            this.positionSource = new BlockPositionSource(blockPos);
        }

        public int m_280351_() {
            return 8;
        }

        @NotNull
        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215854_;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel p_282127_, BlockPos p_283268_, GameEvent p_282187_, @Nullable GameEvent.Context p_282856_) {
            return !SculkNestBlockEntity.this.m_58901_() && p_282856_ != null && SculkShriekerBlockEntity.m_222861_((Entity)p_282856_.f_223711_()) != null;
        }

        public void m_280271_(ServerLevel p_282851_, BlockPos p_281608_, GameEvent p_282979_, @Nullable Entity p_282123_, @Nullable Entity p_283090_, float p_283130_) {
            SculkNestBlockEntity.this.trySpawn(SculkNestBlockEntity.this.f_58857_, SculkShriekerBlockEntity.m_222861_((Entity)(p_283090_ != null ? p_283090_ : p_282123_)));
        }

        public void m_280022_() {
            SculkNestBlockEntity.this.m_6596_();
        }
    }
}

