/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.Settings;
import baritone.api.utils.BlockUtils;
import baritone.api.utils.TypeUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class SettingsUtil {
    private static final Path SETTINGS_PATH = class_310.method_1551().field_1697.toPath().resolve("baritone").resolve("settings.txt");
    private static final Pattern SETTING_PATTERN = Pattern.compile("^(?<setting>[^ ]+) +(?<value>.+)");
    private static final String[] JAVA_ONLY_SETTINGS = new String[]{"logger", "notifier", "toaster"};

    private static boolean isComment(String string) {
        return string.startsWith("#") || string.startsWith("//");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void forEachLine(Path object, Consumer<String> consumer) {
        object = Files.newBufferedReader((Path)object);
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.isEmpty() || SettingsUtil.isComment(string)) continue;
                consumer.accept(string);
            }
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((BufferedReader)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((BufferedReader)object).close();
    }

    public static void readAndApply(Settings settings) {
        try {
            SettingsUtil.forEachLine(SETTINGS_PATH, string -> {
                Object object = SETTING_PATTERN.matcher((CharSequence)string);
                if (!((Matcher)object).matches()) {
                    System.out.println("Invalid syntax in setting file: " + string);
                    return;
                }
                String string2 = ((Matcher)object).group("setting").toLowerCase();
                object = ((Matcher)object).group("value");
                try {
                    SettingsUtil.parseAndApply(settings, string2, (String)object);
                    return;
                }
                catch (Exception exception) {
                    System.out.println("Unable to parse line " + string);
                    exception.printStackTrace();
                    return;
                }
            });
            return;
        }
        catch (NoSuchFileException noSuchFileException) {
            System.out.println("Baritone settings file not found, resetting.");
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception while reading Baritone settings, some settings may be reset to default values!");
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void save(Settings iterator) {
        try {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(SETTINGS_PATH, new OpenOption[0]);){
                for (Settings.Setting setting : SettingsUtil.modifiedSettings(iterator)) {
                    bufferedWriter.write(SettingsUtil.settingToString(setting) + "\n");
                }
                if (bufferedWriter == null) return;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception thrown while saving Baritone settings!");
            exception.printStackTrace();
            return;
        }
    }

    public static List<Settings.Setting> modifiedSettings(Settings object) {
        ArrayList<Settings.Setting> arrayList = new ArrayList<Settings.Setting>();
        for (Settings.Setting<?> setting : ((Settings)((Object)object)).allSettings) {
            if (setting.value == null) {
                System.out.println("NULL SETTING?" + setting.getName());
                continue;
            }
            if (SettingsUtil.javaOnlySetting(setting) || setting.value == setting.defaultValue) continue;
            arrayList.add(setting);
        }
        return arrayList;
    }

    public static String settingTypeToString(Settings.Setting setting) {
        return setting.getType().getTypeName().replaceAll("(?:\\w+\\.)+(\\w+)", "$1");
    }

    public static <T> String settingValueToString(Settings.Setting<T> setting, T t) {
        Parser parser = Parser.getParser(setting.getType());
        if (parser == null) {
            throw new IllegalStateException("Missing " + setting.getValueClass() + " " + setting.getName());
        }
        return parser.toString(new ParserContext(setting), (Object)t);
    }

    public static String settingValueToString(Settings.Setting setting) {
        Settings.Setting setting2 = setting;
        return SettingsUtil.settingValueToString(setting2, setting2.value);
    }

    public static String settingDefaultToString(Settings.Setting setting) {
        Settings.Setting setting2 = setting;
        return SettingsUtil.settingValueToString(setting2, setting2.defaultValue);
    }

    public static String maybeCensor(int n) {
        if (((Boolean)BaritoneAPI.getSettings().censorCoordinates.value).booleanValue()) {
            return "<censored>";
        }
        return Integer.toString(n);
    }

    public static String settingToString(Settings.Setting setting) {
        if (SettingsUtil.javaOnlySetting(setting)) {
            return setting.getName();
        }
        return setting.getName() + " " + SettingsUtil.settingValueToString(setting);
    }

    public static boolean javaOnlySetting(Settings.Setting setting) {
        String[] stringArray = JAVA_ONLY_SETTINGS;
        int n = JAVA_ONLY_SETTINGS.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!setting.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void parseAndApply(Settings setting, String clazz, String string) {
        Parser parser;
        setting = ((Settings)((Object)setting)).byLowerName.get(clazz);
        if (setting == null) {
            throw new IllegalStateException("No setting by that name");
        }
        clazz = setting.getValueClass();
        if (!clazz.isInstance(string = (parser = Parser.getParser(setting.getType())).parse(new ParserContext(setting), string))) {
            String string2 = string;
            throw new IllegalStateException(parser + " parser returned incorrect type, expected " + clazz + " got " + string2 + " which is " + string2.getClass());
        }
        setting.value = string;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Parser implements ISettingParser
    {
        DOUBLE(Double.class, Double::parseDouble),
        BOOLEAN(Boolean.class, Boolean::parseBoolean),
        INTEGER(Integer.class, Integer::parseInt),
        FLOAT(Float.class, Float::parseFloat),
        LONG(Long.class, Long::parseLong),
        STRING(String.class, String::new),
        DIRECTION(class_2350.class, class_2350::method_10168),
        COLOR(Color.class, string -> new Color(Integer.parseInt(string.split(",")[0]), Integer.parseInt(string.split(",")[1]), Integer.parseInt(string.split(",")[2])), color -> color.getRed() + "," + color.getGreen() + "," + color.getBlue()),
        VEC3I(class_2382.class, string -> new class_2382(Integer.parseInt(string.split(",")[0]), Integer.parseInt(string.split(",")[1]), Integer.parseInt(string.split(",")[2])), class_23822 -> class_23822.method_10263() + "," + class_23822.method_10264() + "," + class_23822.method_10260()),
        BLOCK(class_2248.class, string -> BlockUtils.stringToBlockRequired(string.trim()), BlockUtils::blockToString),
        ITEM(class_1792.class, string -> (class_1792)class_7923.field_41178.method_10223(new class_2960(string.trim())), class_17922 -> class_7923.field_41178.method_10221(class_17922).toString()),
        LIST{

            @Override
            public final Object parse(ParserContext parserContext, String string2) {
                Parser parser = Parser.getParser(((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[0]);
                return Stream.of(string2.split(",")).map(string -> parser.parse(parserContext, (String)string)).collect(Collectors.toList());
            }

            @Override
            public final String toString(ParserContext parserContext, Object object2) {
                Parser parser = Parser.getParser(((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[0]);
                return ((List)object2).stream().map(object -> parser.toString(parserContext, object)).collect(Collectors.joining(","));
            }

            @Override
            public final boolean accepts(Type type) {
                return List.class.isAssignableFrom(TypeUtils.resolveBaseClass(type));
            }
        }
        ,
        MAPPING{

            @Override
            public final Object parse(ParserContext parserContext, String string2) {
                Object object = ((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[0];
                Object object2 = ((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[1];
                object = Parser.getParser((Type)object);
                object2 = Parser.getParser((Type)object2);
                return Stream.of(string2.split(",(?=[^,]*->)")).map(string -> string.split("->")).collect(Collectors.toMap(arg_0 -> 2.lambda$parse$1((Parser)object, parserContext, arg_0), arg_0 -> 2.lambda$parse$2((Parser)object2, parserContext, arg_0)));
            }

            @Override
            public final String toString(ParserContext parserContext, Object object) {
                Object object2 = ((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[0];
                Object object3 = ((ParameterizedType)parserContext.getSetting().getType()).getActualTypeArguments()[1];
                object2 = Parser.getParser((Type)object2);
                object3 = Parser.getParser((Type)object3);
                return ((Map)object).entrySet().stream().map(arg_0 -> 2.lambda$toString$3((Parser)object2, parserContext, (Parser)object3, arg_0)).collect(Collectors.joining(","));
            }

            @Override
            public final boolean accepts(Type type) {
                return Map.class.isAssignableFrom(TypeUtils.resolveBaseClass(type));
            }

            private static /* synthetic */ String lambda$toString$3(Parser parser, ParserContext parserContext, Parser parser2, Map.Entry entry) {
                return parser.toString(parserContext, entry.getKey()) + "->" + parser2.toString(parserContext, entry.getValue());
            }

            private static /* synthetic */ Object lambda$parse$2(Parser parser, ParserContext parserContext, String[] stringArray) {
                return parser.parse(parserContext, stringArray[1]);
            }

            private static /* synthetic */ Object lambda$parse$1(Parser parser, ParserContext parserContext, String[] stringArray) {
                return parser.parse(parserContext, stringArray[0]);
            }
        };

        private final Class<?> cla$$;
        private final Function<String, Object> parser;
        private final Function<Object, String> toString;

        Parser() {
            this.cla$$ = null;
            this.parser = null;
            this.toString = null;
        }

        private <T> Parser(Class<T> clazz, Function<String, T> function) {
            this(clazz, function, Object::toString);
        }

        private <T> Parser(Class<T> clazz, Function<String, T> function, Function<T, String> function2) {
            this.cla$$ = clazz;
            this.parser = function::apply;
            this.toString = object -> (String)function2.apply(object);
        }

        public Object parse(ParserContext object, String string) {
            object = this.parser.apply(string);
            Objects.requireNonNull(object);
            return object;
        }

        public String toString(ParserContext parserContext, Object object) {
            return this.toString.apply(object);
        }

        @Override
        public boolean accepts(Type type) {
            return type instanceof Class && this.cla$$.isAssignableFrom((Class)type);
        }

        public static Parser getParser(Type type) {
            return Stream.of(Parser.values()).filter(parser -> parser.accepts(type)).findFirst().orElse(null);
        }
    }

    static class ParserContext {
        private final Settings.Setting<?> setting;

        ParserContext(Settings.Setting<?> setting) {
            this.setting = setting;
        }

        Settings.Setting<?> getSetting() {
            return this.setting;
        }
    }

    static interface ISettingParser<T> {
        public T parse(ParserContext var1, String var2);

        public String toString(ParserContext var1, T var2);

        public boolean accepts(Type var1);
    }
}

