/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.defaults;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.Settings;
import baritone.api.command.Command;
import baritone.api.command.IBaritoneChatControl;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.helpers.Paginator;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.utils.SettingsUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class SetCommand
extends Command {
    public SetCommand(IBaritone iBaritone) {
        super(iBaritone, "set", "setting", "settings");
    }

    @Override
    public void execute(String object, IArgConsumer iArgConsumer) {
        Object object2 = object = iArgConsumer.hasAny() ? iArgConsumer.getString().toLowerCase(Locale.US) : "list";
        if (Arrays.asList("s", "save").contains(object)) {
            SettingsUtil.save(Baritone.a());
            this.logDirect("Settings saved");
            return;
        }
        boolean bl = Arrays.asList("m", "mod", "modified").contains(object);
        boolean bl2 = Arrays.asList("all", "l", "list").contains(object);
        if (bl || bl2) {
            String string = iArgConsumer.hasAny() && iArgConsumer.peekAsOrNull(Integer.class) == null ? iArgConsumer.getString() : "";
            iArgConsumer.requireMax(1);
            List list = (bl ? SettingsUtil.modifiedSettings(Baritone.a()) : Baritone.a().allSettings).stream().filter(setting -> !SettingsUtil.javaOnlySetting(setting)).filter(setting -> setting.getName().toLowerCase(Locale.US).contains(string.toLowerCase(Locale.US))).sorted((setting, setting2) -> String.CASE_INSENSITIVE_ORDER.compare(setting.getName(), setting2.getName())).collect(Collectors.toList());
            Paginator.paginate(iArgConsumer, new Paginator(list), () -> {
                String string2;
                Object[] objectArray;
                String string3;
                if (!string.isEmpty()) {
                    string3 = "All %ssettings containing the string '%s':";
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = bl ? "modified " : "";
                    v2 = objectArray2;
                    objectArray = objectArray2;
                    v4 = 1;
                    string2 = string;
                } else {
                    string3 = "All %ssettings:";
                    Object[] objectArray3 = new Object[1];
                    v2 = objectArray3;
                    objectArray = objectArray3;
                    v4 = 0;
                    string2 = bl ? "modified " : "";
                }
                v2[v4] = string2;
                this.logDirect(String.format(string3, objectArray));
            }, setting -> {
                class_5250 class_52502 = class_2561.method_43470((String)String.format(" (%s)", SettingsUtil.settingTypeToString(setting)));
                class_52502.method_10862(class_52502.method_10866().method_10977(class_124.field_1063));
                class_5250 class_52503 = class_2561.method_43470((String)"");
                class_52503.method_10862(class_52503.method_10866().method_10977(class_124.field_1080));
                class_52503.method_27693(setting.getName());
                class_52503.method_27693(String.format("\nType: %s", SettingsUtil.settingTypeToString(setting)));
                class_52503.method_27693(String.format("\n\nValue:\n%s", SettingsUtil.settingValueToString(setting)));
                class_52503.method_27693(String.format("\n\nDefault Value:\n%s", SettingsUtil.settingDefaultToString(setting)));
                String string = (String)Baritone.a().prefix.value + String.format("set %s ", setting.getName());
                setting = class_2561.method_43470((String)setting.getName());
                setting.method_10862(setting.method_10866().method_10977(class_124.field_1080));
                setting.method_10852((class_2561)class_52502);
                Settings.Setting setting2 = setting;
                setting2.method_10862(setting2.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_52503)).method_10958(new class_2558(class_2558.class_2559.field_11745, string)));
                return setting;
            }, IBaritoneChatControl.FORCE_COMMAND_PREFIX + "set " + (String)object + " " + string);
            return;
        }
        iArgConsumer.requireMax(1);
        bl2 = ((String)object).equalsIgnoreCase("reset");
        boolean bl3 = ((String)object).equalsIgnoreCase("toggle");
        boolean bl4 = bl = bl2 || bl3;
        if (bl2) {
            if (!iArgConsumer.hasAny()) {
                this.logDirect("Please specify 'all' as an argument to reset to confirm you'd really like to do this");
                this.logDirect("ALL settings will be reset. Use the 'set modified' or 'modified' commands to see what will be reset.");
                this.logDirect("Specify a setting name instead of 'all' to only reset one setting");
            } else if (iArgConsumer.peekString().equalsIgnoreCase("all")) {
                SettingsUtil.modifiedSettings(Baritone.a()).forEach(Settings.Setting::reset);
                this.logDirect("All settings have been reset to their default values");
                SettingsUtil.save(Baritone.a());
                return;
            }
        }
        if (bl3) {
            iArgConsumer.requireMin(1);
        }
        Object object3 = bl ? iArgConsumer.getString() : object;
        object3 = Baritone.a().allSettings.stream().filter(arg_0 -> SetCommand.a((String)object3, arg_0)).findFirst().orElse(null);
        if (object3 == null) {
            throw new CommandInvalidTypeException(iArgConsumer.consumed(), "a valid setting");
        }
        if (SettingsUtil.javaOnlySetting((Settings.Setting)object3)) {
            throw new CommandInvalidStateException(String.format("Setting %s can only be used via the api.", ((Settings.Setting)object3).getName()));
        }
        if (!bl && !iArgConsumer.hasAny()) {
            this.logDirect(String.format("Value of setting %s:", ((Settings.Setting)object3).getName()));
            this.logDirect(SettingsUtil.settingValueToString((Settings.Setting)object3));
        } else {
            String string;
            String string2 = SettingsUtil.settingValueToString((Settings.Setting)object3);
            if (bl2) {
                ((Settings.Setting)object3).reset();
            } else if (bl3) {
                if (((Settings.Setting)object3).getValueClass() != Boolean.class) {
                    throw new CommandInvalidTypeException(iArgConsumer.consumed(), "a toggleable setting", "some other setting");
                }
                ((Settings.Setting)object3).value = (Boolean)((Settings.Setting)object3).value ^ true;
                this.logDirect(String.format("Toggled setting %s to %s", ((Settings.Setting)object3).getName(), Boolean.toString((Boolean)((Settings.Setting)object3).value)));
            } else {
                string = iArgConsumer.getString();
                try {
                    SettingsUtil.parseAndApply(Baritone.a(), (String)object, string);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throwable.printStackTrace();
                    throw new CommandInvalidTypeException(iArgConsumer.consumed(), "a valid value", (Throwable)object);
                }
            }
            if (!bl3) {
                this.logDirect(String.format("Successfully %s %s to %s", bl2 ? "reset" : "set", ((Settings.Setting)object3).getName(), SettingsUtil.settingValueToString((Settings.Setting)object3)));
            }
            string = class_2561.method_43470((String)String.format("Old value: %s", string2));
            string.method_10862(string.method_10866().method_10977(class_124.field_1080).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to set the setting back to this value"))).method_10958(new class_2558(class_2558.class_2559.field_11750, IBaritoneChatControl.FORCE_COMMAND_PREFIX + String.format("set %s %s", ((Settings.Setting)object3).getName(), string2))));
            this.logDirect(new class_2561[]{string});
            if (((Settings.Setting)object3).getName().equals("chatControl") && !((Boolean)((Settings.Setting)object3).value).booleanValue() && !((Boolean)Baritone.a().chatControlAnyway.value).booleanValue() || ((Settings.Setting)object3).getName().equals("chatControlAnyway") && !((Boolean)((Settings.Setting)object3).value).booleanValue() && !((Boolean)Baritone.a().chatControl.value).booleanValue()) {
                this.logDirect("Warning: Chat commands will no longer work. If you want to revert this change, use prefix control (if enabled) or click the old value listed above.", class_124.field_1061);
            } else if (((Settings.Setting)object3).getName().equals("prefixControl") && !((Boolean)((Settings.Setting)object3).value).booleanValue()) {
                this.logDirect("Warning: Prefixed commands will no longer work. If you want to revert this change, use chat control (if enabled) or click the old value listed above.", class_124.field_1061);
            }
        }
        SettingsUtil.save(Baritone.a());
    }

    @Override
    public Stream<String> tabComplete(String object, IArgConsumer iArgConsumer) {
        if (iArgConsumer.hasAny()) {
            object = iArgConsumer.getString();
            if (iArgConsumer.hasExactlyOne() && !Arrays.asList("s", "save").contains(iArgConsumer.peekString().toLowerCase(Locale.US))) {
                if (((String)object).equalsIgnoreCase("reset")) {
                    return new TabCompleteHelper().addModifiedSettings().prepend("all").filterPrefix(iArgConsumer.getString()).stream();
                }
                if (((String)object).equalsIgnoreCase("toggle")) {
                    return new TabCompleteHelper().addToggleableSettings().filterPrefix(iArgConsumer.getString()).stream();
                }
                if ((object = Baritone.a().byLowerName.get(((String)object).toLowerCase(Locale.US))) != null) {
                    if (((Settings.Setting)object).getType() == Boolean.class) {
                        TabCompleteHelper tabCompleteHelper = new TabCompleteHelper();
                        if (((Boolean)((Settings.Setting)object).value).booleanValue()) {
                            tabCompleteHelper.append("true", "false");
                        } else {
                            tabCompleteHelper.append("false", "true");
                        }
                        return tabCompleteHelper.filterPrefix(iArgConsumer.getString()).stream();
                    }
                    return Stream.of(SettingsUtil.settingValueToString((Settings.Setting)object));
                }
            } else if (!iArgConsumer.hasAny()) {
                return new TabCompleteHelper().addSettings().sortAlphabetically().prepend("list", "modified", "reset", "toggle", "save").filterPrefix((String)object).stream();
            }
        }
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "View or change settings";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("Using the set command, you can manage all of Baritone's settings. Almost every aspect is controlled by these settings - go wild!", "", "Usage:", "> set - Same as `set list`", "> set list [page] - View all settings", "> set modified [page] - View modified settings", "> set <setting> - View the current value of a setting", "> set <setting> <value> - Set the value of a setting", "> set reset all - Reset ALL SETTINGS to their defaults", "> set reset <setting> - Reset a setting to its default", "> set toggle <setting> - Toggle a boolean setting", "> set save - Save all settings (this is automatic tho)");
    }

    private static /* synthetic */ boolean a(String string, Settings.Setting setting) {
        return setting.getName().equalsIgnoreCase(string);
    }
}

