/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.ayutaki.chinjufumod.blocks.furniture.Tansu;
import com.ayutaki.chinjufumod.gui.TansuMenu;
import com.ayutaki.chinjufumod.handler.MenuTypes_CM;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.handler.TileEntity_CM;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class Tansu_TileEntity
extends LockableLootTileEntity
implements ITickableTileEntity {
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)45, (Object)ItemStack.field_190927_a);
    protected float lidAngle;
    protected float prevLidAngle;
    private int ticksSinceSync;
    protected int numPlayersUsing;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    public Tansu_TileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public Tansu_TileEntity() {
        this(TileEntity_CM.TANSU);
    }

    public int func_70302_i_() {
        return 45;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory inventory) {
        return new TansuMenu((ContainerType)MenuTypes_CM.TANSU_MENU.get(), id, inventory, (IInventory)this);
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    public void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.chestContents);
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.chestContents);
        }
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.numPlayersUsing = Tansu_TileEntity.calculatePlayersUsingSync(this.field_145850_b, (LockableTileEntity)this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)Tansu.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playSound(SoundEvents_CM.TANSU_OPEN);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)Tansu.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playSound(SoundEvents_CM.TANSU_CLOSE);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)Tansu.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public static int calculatePlayersUsingSync(World worldIn, LockableTileEntity lTileEntity, int ticksSinceSync, int x, int y, int z, int numPlayerUsing) {
        if (!worldIn.field_72995_K && numPlayerUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayerUsing = Tansu_TileEntity.calculatePlayersUsing(worldIn, lTileEntity, x, y, z);
        }
        return numPlayerUsing;
    }

    public static int calculatePlayersUsing(World worldIn, LockableTileEntity lTileEntity, int x, int y, int z) {
        int i = 0;
        for (PlayerEntity playerIn : worldIn.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerIn.field_71070_bA instanceof TansuMenu) || (iinventory = ((TansuMenu)playerIn.field_71070_bA).getLowerChestInventory()) != lTileEntity) continue;
            ++i;
        }
        return i;
    }

    private void playSound(SoundEvent sound) {
        double dx = (double)this.field_174879_c.func_177958_n() + 0.5;
        double dy = (double)this.field_174879_c.func_177956_o() + 0.5;
        double dz = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, dx, dy, dz, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity playerIn) {
        if (!playerIn.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity playerIn) {
        if (!playerIn.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof Tansu) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLidAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public static int getPlayersUsing(IBlockReader reader, BlockPos pos) {
        TileEntity tileentity;
        BlockState state = reader.func_180495_p(pos);
        if (state.hasTileEntity() && (tileentity = reader.func_175625_s(pos)) instanceof Tansu_TileEntity) {
            return ((Tansu_TileEntity)tileentity).numPlayersUsing;
        }
        return 0;
    }

    public static void swapContents(Tansu_TileEntity te, Tansu_TileEntity otherTe) {
        NonNullList<ItemStack> list = te.func_190576_q();
        te.func_199721_a(otherTe.func_190576_q());
        otherTe.func_199721_a(list);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

