/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.ayutaki.chinjufumod.blocks.furnace.AbstractStoveBlock;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractStoveTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int recipesUsed;
    private int cookTime;
    private int cookTimeTotal;
    protected final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractStoveTileEntity.this.burnTime;
                }
                case 1: {
                    return AbstractStoveTileEntity.this.recipesUsed;
                }
                case 2: {
                    return AbstractStoveTileEntity.this.cookTime;
                }
                case 3: {
                    return AbstractStoveTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractStoveTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractStoveTileEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    AbstractStoveTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    AbstractStoveTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Map<ResourceLocation, Integer> map = Maps.newHashMap();
    protected final IRecipeType<? extends AbstractCookingRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractStoveTileEntity(TileEntityType<?> tileTypeIn, IRecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileTypeIn);
        this.recipeType = recipeTypeIn;
    }

    @Deprecated
    public static Map<Item, Integer> getBurnTimes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151129_at, 20000);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150402_ci, 16000);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151072_bj, 2400);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151044_h, 1600);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_196155_l, 1600);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_200038_h, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_199905_b, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_202898_h, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_202899_i, 150);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_212188_k, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_202900_j, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)Tags.Items.FENCES_WOODEN, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)Tags.Items.FENCE_GATES_WOODEN, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_196586_al, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150342_X, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222428_lQ, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150421_aI, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150486_ae, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150447_bR, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150462_ai, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150453_bW, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_202901_n, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151031_f, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151112_aM, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_150468_ap, 300);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_219773_J, 200);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151038_n, 200);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151041_m, 200);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151017_I, 200);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151053_p, 200);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151039_o, 200);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_200154_g, 200);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_202902_o, 1200);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_199904_a, 100);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_200153_d, 100);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151055_y, 100);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_200037_g, 100);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_151054_z, 100);
        AbstractStoveTileEntity.addItemTagBurnTime(map, (Tag<Item>)ItemTags.field_200035_e, 67);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_203216_jz, 4001);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Items.field_222114_py, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222405_kQ, 50);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_196555_aI, 100);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222420_lI, 400);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222421_lJ, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222422_lK, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222425_lN, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222426_lO, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222429_lR, 300);
        AbstractStoveTileEntity.addItemBurnTime(map, (IItemProvider)Blocks.field_222436_lZ, 300);
        return map;
    }

    private static void addItemTagBurnTime(Map<Item, Integer> map, Tag<Item> itemTag, int burnTimeIn) {
        for (Item item : itemTag.func_199885_a()) {
            map.put(item, burnTimeIn);
        }
    }

    private static void addItemBurnTime(Map<Item, Integer> map, IItemProvider itemProvider, int burnTimeIn) {
        map.put(itemProvider.func_199767_j(), burnTimeIn);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.recipesUsed = this.getBurnTime((ItemStack)this.items.get(1));
        int i = compound.func_74765_d("RecipesUsedSize");
        for (int j = 0; j < i; ++j) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.func_74779_i("RecipeLocation" + j));
            int k = compound.func_74762_e("RecipeAmount" + j);
            this.map.put(resourcelocation, k);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        compound.func_74777_a("RecipesUsedSize", (short)this.map.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.map.entrySet()) {
            compound.func_74778_a("RecipeLocation" + i, entry.getKey().toString());
            compound.func_74768_a("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = (ItemStack)this.items.get(1);
            if (this.isBurning() || !stack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    this.recipesUsed = this.burnTime = this.getBurnTime(stack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (stack.hasContainerItem()) {
                            this.items.set(1, (Object)stack.getContainerItem());
                        } else if (!stack.func_190926_b()) {
                            stack.func_190918_g(1);
                            if (stack.func_190926_b()) {
                                this.items.set(1, (Object)stack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.smelt(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)AbstractStoveBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipeIn) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipeIn != null) {
            ItemStack stack = recipeIn.func_77571_b();
            if (stack.func_190926_b()) {
                return false;
            }
            ItemStack stack1 = (ItemStack)this.items.get(2);
            if (stack1.func_190926_b()) {
                return true;
            }
            if (!stack1.func_77969_a(stack)) {
                return false;
            }
            if (stack1.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && stack1.func_190916_E() + stack.func_190916_E() <= stack1.func_77976_d()) {
                return true;
            }
            return stack1.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
        }
        return false;
    }

    private void smelt(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack stack = (ItemStack)this.items.get(0);
            ItemStack stack1 = recipe.func_77571_b();
            ItemStack stack2 = (ItemStack)this.items.get(2);
            if (stack2.func_190926_b()) {
                this.items.set(2, (Object)stack1.func_77946_l());
            } else if (stack2.func_77973_b() == stack1.func_77973_b()) {
                stack2.func_190917_f(stack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (stack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.items.get(1)).func_190926_b() && ((ItemStack)this.items.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.items.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            stack.func_190918_g(1);
        }
    }

    protected int getBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel) / 2 * 3;
    }

    protected int getCookTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack countStack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(countStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)countStack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity playerIn) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return playerIn.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack countStack = (ItemStack)this.items.get(1);
        return AbstractStoveTileEntity.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && countStack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.map.compute(recipe.func_199560_c(), (p_214004_0_, p_214004_1_) -> 1 + (p_214004_1_ == null ? 0 : p_214004_1_));
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity playerIn) {
    }

    public void func_213995_d(PlayerEntity playerIn) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.map.entrySet()) {
            playerIn.field_70170_p.func_199532_z().func_215367_a(entry.getKey()).ifPresent(p_213993_3_ -> {
                list.add(p_213993_3_);
                AbstractStoveTileEntity.spawnExpOrbs(playerIn, (Integer)entry.getValue(), ((AbstractCookingRecipe)p_213993_3_).func_222138_b());
            });
        }
        playerIn.func_195065_a((Collection)list);
        this.map.clear();
    }

    private static void spawnExpOrbs(PlayerEntity playerIn, int t, float experience) {
        if (experience == 0.0f) {
            t = 0;
        } else if (experience < 1.0f) {
            int i = MathHelper.func_76141_d((float)((float)t * experience));
            if (i < MathHelper.func_76123_f((float)((float)t * experience)) && Math.random() < (double)((float)t * experience - (float)i)) {
                ++i;
            }
            t = i;
        }
        while (t > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)t);
            t -= j;
            playerIn.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(playerIn.field_70170_p, playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + 0.5, playerIn.func_226281_cx_() + 0.5, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack stack : this.items) {
            helper.func_194112_a(stack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

