/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.items.teatime;

import com.ayutaki.chinjufumod.ItemGroups_CM;
import com.ayutaki.chinjufumod.registry.Items_Teatime;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class MeasureCup_Item
extends BucketItem {
    private final Fluid containedBlock;
    private final Block block;

    public MeasureCup_Item(Fluid containedFluidIn, Block blockIn, Item.Properties properties) {
        super(containedFluidIn, properties.func_200916_a(ItemGroups_CM.TEATIME));
        this.block = blockIn;
        this.containedBlock = containedFluidIn;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = MeasureCup_Item.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.containedBlock == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)stack, (RayTraceResult)raytraceresult);
        boolean mode = playerIn.field_71075_bZ.field_75098_d;
        BlockRayTraceResult blockResult = (BlockRayTraceResult)raytraceresult;
        BlockPos pos = blockResult.func_216350_a();
        Direction direction = blockResult.func_216354_b();
        BlockPos pos1 = pos.func_177972_a(direction);
        BlockState stateIn1 = worldIn.func_180495_p(pos);
        Block block = stateIn1.func_177230_c();
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!playerIn.func_225608_bj_() && worldIn.func_175660_a(playerIn, pos) && playerIn.func_175151_a(pos1, direction, stack) && this.containedBlock == Fluids.field_204541_a) {
            if (stateIn1.func_177230_c() == Blocks.field_150383_bp) {
                int cauldron = (Integer)stateIn1.func_177229_b((IProperty)CauldronBlock.field_176591_a);
                if (cauldron == 0) {
                    return ActionResult.func_226250_c_((Object)stack);
                }
                playerIn.func_195066_a(Stats.field_188078_L);
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ((CauldronBlock)block).func_176590_a(worldIn, pos, stateIn1, cauldron - 1);
                if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items_Teatime.KEIRYO_CUP_full))) {
                    playerIn.func_71019_a(new ItemStack((IItemProvider)Items_Teatime.KEIRYO_CUP_full), false);
                }
                if (!mode) {
                    stack.func_190918_g(1);
                }
                if (mode) {
                    // empty if block
                }
                return ActionResult.func_226248_a_((Object)stack);
            }
            if (worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a)) {
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items_Teatime.KEIRYO_CUP_full))) {
                    playerIn.func_71019_a(new ItemStack((IItemProvider)Items_Teatime.KEIRYO_CUP_full), false);
                }
                if (!mode) {
                    stack.func_190918_g(1);
                }
                if (mode) {
                    // empty if block
                }
                return ActionResult.func_226248_a_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void checkExtraContent(World worldIn, ItemStack stack, BlockPos pos) {
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerIn = context.func_195999_j();
        if (context.func_196000_l() == Direction.UP && playerIn.func_225608_bj_()) {
            return this.tryPlace(new BlockItemUseContext(context));
        }
        return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
    }

    public ActionResultType tryPlace(BlockItemUseContext context) {
        if (!context.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.getBlockItemUseContext(context);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState stateIn = this.getStateForPlacement(blockitemusecontext);
        if (stateIn == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, stateIn)) {
            return ActionResultType.FAIL;
        }
        BlockPos pos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerIn = blockitemusecontext.func_195999_j();
        ItemStack stack = blockitemusecontext.func_195996_i();
        BlockState stateIn1 = world.func_180495_p(pos);
        Block block = stateIn1.func_177230_c();
        if (block == stateIn.func_177230_c()) {
            stateIn1 = this.getBlockStateTag(pos, world, stack, stateIn1);
            this.onBlockPlaced(pos, world, playerIn, stack, stateIn1);
            block.func_180633_a(world, pos, stateIn1, (LivingEntity)playerIn, stack);
            if (playerIn instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, pos, stack);
            }
        }
        SoundType soundtype = stateIn1.getSoundType((IWorldReader)world, pos, (Entity)context.func_195999_j());
        world.func_184133_a(playerIn, pos, this.getPlaceSound(stateIn1, world, pos, context.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState state) {
        return state.func_215695_r().func_185841_e();
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    @Nullable
    public BlockItemUseContext getBlockItemUseContext(BlockItemUseContext context) {
        return context;
    }

    protected boolean onBlockPlaced(BlockPos pos, World worldIn, @Nullable PlayerEntity playerIn, ItemStack stack, BlockState state) {
        return MeasureCup_Item.setTileEntityNBT(worldIn, playerIn, pos, stack);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockItemUseContext context) {
        BlockState stateIn = this.getBlock().func_196258_a(context);
        return stateIn != null && this.canPlace(context, stateIn) ? stateIn : null;
    }

    private BlockState getBlockStateTag(BlockPos pos, World worldIn, ItemStack stack, BlockState state) {
        BlockState stateIn = state;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = state.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                IProperty iproperty = statecontainer.func_185920_a(s);
                if (iproperty == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                stateIn = MeasureCup_Item.comBlockState(stateIn, iproperty, s1);
            }
        }
        if (stateIn != state) {
            worldIn.func_180501_a(pos, stateIn, 2);
        }
        return stateIn;
    }

    private static <T extends Comparable<T>> BlockState comBlockState(BlockState state, IProperty<T> property, String string) {
        return property.func_185929_b(string).map(mapper -> (BlockState)state.func_206870_a(property, mapper)).orElse(state);
    }

    protected boolean canPlace(BlockItemUseContext context, BlockState state) {
        PlayerEntity playerIn = context.func_195999_j();
        ISelectionContext iselectioncontext = playerIn == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerIn);
        return (!this.checkPosition() || state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) && context.func_195991_k().func_226663_a_(state, context.func_195995_a(), iselectioncontext);
    }

    protected boolean checkPosition() {
        return true;
    }

    protected boolean placeBlock(BlockItemUseContext context, BlockState state) {
        return context.func_195991_k().func_180501_a(context.func_195995_a(), state, 11);
    }

    public static boolean setTileEntityNBT(World worldIn, @Nullable PlayerEntity playerIn, BlockPos pos, ItemStack stack) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (tileentity = worldIn.func_175625_s(pos)) != null) {
            if (!(worldIn.field_72995_K || !tileentity.func_183000_F() || playerIn != null && playerIn.func_195070_dx())) {
                return false;
            }
            CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
            CompoundNBT compoundnbt2 = compoundnbt1.func_74737_b();
            compoundnbt1.func_197643_a(compoundnbt);
            compoundnbt1.func_74768_a("x", pos.func_177958_n());
            compoundnbt1.func_74768_a("y", pos.func_177956_o());
            compoundnbt1.func_74768_a("z", pos.func_177952_p());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.func_145839_a(compoundnbt1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)this.getBlockRaw().delegate.get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void addToBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.put(this.getBlock(), itemIn);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag tipFlag) {
        super.func_77624_a(stack, worldIn, tooltip, tipFlag);
        tooltip.add(new TranslationTextComponent("tips.block_measurecup", new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add(new TranslationTextComponent("tips.block_simpledish", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }
}

