/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.entity.helper.Vector3;
import com.ayutaki.chinjufumod.handler.EntityTypes_CM;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.registry.Items_Weapon;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class KK_Ju87Entity
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<Integer> RETURN_TO = EntityDataManager.func_187226_a(KK_Ju87Entity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private ItemStack stack = new ItemStack((IItemProvider)Items_Weapon.JU87);
    private double baseDamage = 9.0;

    public KK_Ju87Entity(EntityType<KK_Ju87Entity> type, World worldIn) {
        super(type, worldIn);
    }

    public KK_Ju87Entity(LivingEntity entity, World worldIn, ItemStack stack) {
        super(EntityTypes_CM.JU87, entity, worldIn);
        this.stack = stack.func_77946_l();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RETURN_TO, (Object)-1);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_184185_a(SoundEvents_CM.KK_PROPELLER, 2.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity thrower = this.func_85052_h();
            if (this.isReturning()) {
                if (thrower == null && this.field_70173_aa > 200) {
                    this.dropAndKill();
                }
                if (thrower != null) {
                    Vector3 motion = Vector3.fromEntityCenter((Entity)thrower).subtract(Vector3.fromEntityCenter((Entity)this)).normalize();
                    this.func_213317_d(motion.toVec3D());
                    if (this.func_70068_e((Entity)thrower) < 2.0) {
                        this.dropAndKill();
                    }
                }
            }
            if (!this.isReturning()) {
                if (thrower == null && this.field_70173_aa > 200) {
                    this.dropAndKill();
                }
                if (thrower != null && this.field_70173_aa >= 60) {
                    this.setEntityToReturnTo(this.getEntityToReturnTo() + 1);
                }
            }
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)item);
        this.func_70106_y();
    }

    private ItemStack getItemStack() {
        return this.stack.func_77946_l();
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return this.getItemStack();
    }

    protected void func_70184_a(@Nonnull RayTraceResult result) {
        switch (result.func_216346_c()) {
            case BLOCK: {
                BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
                Block block = this.field_70170_p.func_180495_p(blockResult.func_216350_a()).func_177230_c();
                if (!(block instanceof Block)) break;
                return;
            }
            case ENTITY: {
                EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
                LivingEntity thrower = this.func_85052_h();
                if (this.field_70170_p.field_72995_K || !(entityResult.func_216348_a() instanceof LivingEntity) || entityResult.func_216348_a() == thrower) break;
                if (entityResult.func_216348_a() instanceof VillagerEntity || entityResult.func_216348_a() instanceof HorseEntity || entityResult.func_216348_a() instanceof DonkeyEntity || entityResult.func_216348_a() instanceof TameableEntity) {
                    this.func_70099_a(this.getItemStack(), 0.5f);
                    this.func_184185_a(SoundEvents_CM.KK_STOP, 2.0f, 1.0f);
                    this.func_70106_y();
                    break;
                }
                double atackDamage = this.baseDamage;
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)this.stack);
                if (j == 0) {
                    entityResult.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)atackDamage);
                }
                if (j > 0) {
                    entityResult.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)atackDamage + (float)j * 0.5f);
                }
                this.func_184185_a(SoundEvents_CM.KK_ATACK, 2.0f, 1.0f);
                break;
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.field_70180_af.func_187225_a(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.field_70180_af.func_187227_b(RETURN_TO, (Object)entityID);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.stack.func_190926_b()) {
            compound.func_218657_a("fly_stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74780_a("damage", this.baseDamage);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fly_stack")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("fly_stack"));
        }
        if (compound.func_150297_b("damage", 99)) {
            this.baseDamage = compound.func_74769_h("damage");
        }
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }
}

