/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AmmoAbstract_Entity
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(AmmoAbstract_Entity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(AmmoAbstract_Entity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(AmmoAbstract_Entity.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    public PickupStatus pickupStatus = PickupStatus.DISALLOWED;
    public int arrowShake;
    public UUID shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 3.0;
    private int knockbackStrength;
    private SoundEvent hitSound = this.getHitEntitySound();
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;

    protected AmmoAbstract_Entity(EntityType<? extends AmmoAbstract_Entity> type, World worldIn) {
        super(type, worldIn);
    }

    protected AmmoAbstract_Entity(EntityType<? extends AmmoAbstract_Entity> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected AmmoAbstract_Entity(EntityType<? extends AmmoAbstract_Entity> type, LivingEntity shooter, World worldIn) {
        this(type, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.setShooter((Entity)shooter);
        if (shooter instanceof PlayerEntity) {
            this.pickupStatus = PickupStatus.ALLOWED;
        }
    }

    public void setHitSound(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * AmmoAbstract_Entity.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.field_70122_E ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)AmmoAbstract_Entity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos pos;
        BlockState state;
        super.func_70071_h_();
        boolean flag = this.getNoClip();
        Vec3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AmmoAbstract_Entity.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((state = this.field_70170_p.func_180495_p(pos = new BlockPos((Entity)this))).isAir((IBlockReader)this.field_70170_p, pos) || flag || (voxelshape = state.func_196952_d((IBlockReader)this.field_70170_p, pos)).func_197766_b())) {
            Vec3d vec3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(pos).func_72318_a(vec3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround && !flag) {
            if (this.inBlockState != state && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                this.inGround = false;
                this.func_213317_d(vec3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.timeInGround;
        } else {
            Vec3d vec3d3;
            this.timeInGround = 0;
            ++this.ticksInAir;
            Vec3d vec3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d2, vec3d3 = vec3d2.func_178787_e(vec3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.getShooter();
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onHit((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
                raytraceresult = null;
            }
            vec3d = this.func_213322_ci();
            double d3 = vec3d.field_72450_a;
            double d4 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + d3 * (double)i / 4.0, this.func_226278_cu_() + d4 * (double)i / 4.0, this.func_226281_cx_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AmmoAbstract_Entity.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.getWaterDrag();
            }
            this.func_213317_d(vec3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !flag) {
                Vec3d vec3d4 = this.func_213322_ci();
                this.func_213293_j(vec3d4.field_72450_a, vec3d4.field_72448_b - (double)0.05f, vec3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
    }

    protected void func_225516_i_() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 1200) {
            this.func_70106_y();
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onEntityHit((EntityRayTraceResult)raytraceResultIn);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockState state;
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            this.inBlockState = state = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.func_226288_n_(this.func_226277_ct_() - vec3d1.field_72450_a, this.func_226278_cu_() - vec3d1.field_72448_b, this.func_226281_cx_() - vec3d1.field_72449_c);
            this.func_184185_a(this.getHitGroundSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.inGround = true;
            this.arrowShake = 7;
            this.setIsCritical(false);
            this.setPierceLevel((byte)0);
            this.setHitSound(SoundEvents_CM.AM_IMPACT);
            this.setShotFromCrossbow(false);
            this.func_213870_w();
            state.func_215690_a(this.field_70170_p, state, blockraytraceresult, (Entity)this);
        }
    }

    private void func_213870_w() {
        if (this.hitEntities != null) {
            this.hitEntities.clear();
        }
        if (this.piercedEntities != null) {
            this.piercedEntities.clear();
        }
    }

    protected void onEntityHit(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)Math.max((double)f * this.damage, 0.0));
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if (this.getIsCritical()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        if ((entity1 = this.getShooter()) == null) {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int j = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3d vec3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.getPierceLevel() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.knockbackStrength > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.arrowHit(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity1;
                    if (this.hitEntities != null && this.getShotFromCrossbow()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, this.hitEntities, this.hitEntities.size());
                    } else if (!entity.func_70089_S() && this.getShotFromCrossbow()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, Arrays.asList(entity), 0);
                    }
                }
            }
            this.func_184185_a(this.hitSound, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_223308_g(j);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.pickupStatus == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.getArrowStack(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents_CM.AM_IMPACT;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    protected void arrowHit(LivingEntity living) {
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)startVec, (Vec3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !(p_213871_1_.func_175149_v() || !p_213871_1_.func_70089_S() || !p_213871_1_.func_70067_L() || p_213871_1_ == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(p_213871_1_.func_145782_y())));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74757_a("inGround", this.inGround);
        compound.func_74774_a("pickup", (byte)this.pickupStatus.ordinal());
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("crit", this.getIsCritical());
        compound.func_74774_a("PierceLevel", this.getPierceLevel());
        if (this.shootingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.shootingEntity);
        }
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.hitSound).toString());
        compound.func_74757_a("ShotFromCrossbow", this.getShotFromCrossbow());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.pickupStatus = PickupStatus.getByOrdinal(compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.pickupStatus = compound.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.setIsCritical(compound.func_74767_n("crit"));
        this.setPierceLevel(compound.func_74771_c("PierceLevel"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.shootingEntity = compound.func_186857_a("OwnerUUID");
        }
        if (compound.func_150297_b("SoundEvent", 8)) {
            this.hitSound = Registry.field_212633_v.func_218349_b(new ResourceLocation(compound.func_74779_i("SoundEvent"))).orElse(this.getHitEntitySound());
        }
        this.setShotFromCrossbow(compound.func_74767_n("ShotFromCrossbow"));
    }

    public void setShooter(@Nullable Entity entityIn) {
        UUID uUID = this.shootingEntity = entityIn == null ? null : entityIn.func_110124_au();
        if (entityIn instanceof PlayerEntity) {
            this.pickupStatus = ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && (this.inGround || this.getNoClip()) && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == PickupStatus.ALLOWED || this.pickupStatus == PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d || this.getNoClip() && this.getShooter().func_110124_au() == entityIn.func_110124_au();
            if (this.pickupStatus == PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack getArrowStack();

    protected boolean func_225502_at_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public void setIsCritical(boolean critical) {
        this.setArrowFlag(1, critical);
    }

    public void setPierceLevel(byte level) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)level);
    }

    private void setArrowFlag(int p_203049_1_, boolean p_203049_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (p_203049_2_) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | p_203049_1_)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & ~p_203049_1_)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public boolean getShotFromCrossbow() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)p_190547_1_);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)p_190547_1_);
        this.setDamage((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.setDamage(this.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setKnockbackStrength(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    public void setNoClip(boolean noClipIn) {
        this.field_70145_X = noClipIn;
        this.setArrowFlag(2, noClipIn);
    }

    public boolean getNoClip() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return ((Byte)this.field_70180_af.func_187225_a(CRITICAL) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean fromCrossbow) {
        this.setArrowFlag(4, fromCrossbow);
    }

    public IPacket<?> func_213297_N() {
        Entity entity = this.getShooter();
        return new SSpawnObjectPacket((Entity)this, entity == null ? 0 : entity.func_145782_y());
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

