/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.window;

import com.ayutaki.chinjufumod.blocks.base.CM_WaterLogged;
import com.ayutaki.chinjufumod.handler.CMEvents;
import com.ayutaki.chinjufumod.items.color.Base_ItemHake;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class CurtainTall
extends CM_WaterLogged {
    public static final DirectionProperty H_FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final EnumProperty<DoorHingeSide> HINGE = EnumProperty.func_177709_a((String)"hinge", DoorHingeSide.class);
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.func_177709_a((String)"half", DoubleBlockHalf.class);
    protected static final VoxelShape CLOSE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape CLOSE_EAST = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CLOSE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CLOSE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OPENL_NORTH = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.1);
    protected static final VoxelShape OPENL_EAST = Block.func_208617_a((double)13.9, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OPENL_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)13.9, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OPENL_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.1, (double)16.0, (double)2.0);
    protected static final VoxelShape OPENR_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.1);
    protected static final VoxelShape OPENR_EAST = Block.func_208617_a((double)13.9, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape OPENR_SOUTH = Block.func_208617_a((double)14.0, (double)0.0, (double)13.9, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape OPENR_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.1, (double)16.0, (double)16.0);

    public CurtainTall(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)H_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof Base_ItemHake) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            CMEvents.soundWoolPlace(worldIn, pos);
        }
        if (!((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            CMEvents.soundWoolPlace(worldIn, pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void toggleDoor(BlockState state, World worldIn, BlockPos pos, boolean open) {
        BlockState state1 = worldIn.func_180495_p(pos);
        if (state1.func_177230_c() == this && (Boolean)state1.func_177229_b((IProperty)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)state1.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.moveSound(worldIn, pos, open);
        }
    }

    private void moveSound(World worldIn, BlockPos pos, boolean isOpening) {
        if (isOpening) {
            CMEvents.soundWoolPlace(worldIn, pos);
        }
        if (!isOpening) {
            CMEvents.soundWoolPlace(worldIn, pos);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        IFluidState fluid = worldIn.func_204610_c(pos);
        PlayerEntity playerIn = context.func_195999_j();
        if (worldIn.func_180495_p(pos.func_177977_b()).func_196953_a(context)) {
            if (playerIn.func_225608_bj_()) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)H_FACING, (Comparable)context.func_195992_f())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a))).func_206870_a(HINGE, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER);
            }
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)H_FACING, (Comparable)context.func_195992_f())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        IFluidState fluidDown = worldIn.func_204610_c(pos.func_177977_b());
        worldIn.func_180501_a(pos.func_177977_b(), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)H_FACING, state.func_177229_b((IProperty)H_FACING))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidDown.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)H_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)H_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)H_FACING))).func_177231_a(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        BlockState state1 = super.func_196271_a(state, facing, facingState, worldIn, pos, facingPos);
        if (!state1.isAir((IBlockReader)worldIn, pos)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (facing.func_176740_k() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != half ? (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)H_FACING, facingState.func_177229_b((IProperty)H_FACING))).func_206870_a((IProperty)OPEN, facingState.func_177229_b((IProperty)OPEN))).func_206870_a(HINGE, facingState.func_177229_b(HINGE)) : Blocks.field_150350_a.func_176223_P();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.func_196955_c((IWorldReader)worldIn, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, worldIn, pos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)H_FACING);
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean flagopen = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flagright = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (half) {
            default: {
                switch (direction) {
                    default: {
                        return flagopen ? CLOSE_NORTH : (flagright ? OPENL_NORTH : OPENR_NORTH);
                    }
                    case SOUTH: {
                        return flagopen ? CLOSE_SOUTH : (flagright ? OPENL_SOUTH : OPENR_SOUTH);
                    }
                    case WEST: {
                        return flagopen ? CLOSE_WEST : (flagright ? OPENL_WEST : OPENR_WEST);
                    }
                    case EAST: 
                }
                return flagopen ? CLOSE_EAST : (flagright ? OPENL_EAST : OPENR_EAST);
            }
            case UPPER: 
        }
        switch (direction) {
            default: {
                return flagopen ? CLOSE_NORTH : (flagright ? OPENL_NORTH : OPENR_NORTH);
            }
            case SOUTH: {
                return flagopen ? CLOSE_SOUTH : (flagright ? OPENL_SOUTH : OPENR_SOUTH);
            }
            case WEST: {
                return flagopen ? CLOSE_WEST : (flagright ? OPENL_WEST : OPENR_WEST);
            }
            case EAST: 
        }
        return flagopen ? CLOSE_EAST : (flagright ? OPENL_EAST : OPENR_EAST);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity playerIn) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos pos1 = half == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState state1 = worldIn.func_180495_p(pos1);
        if (state1.func_177230_c() == this && state1.func_177229_b(HALF) != half) {
            worldIn.func_180501_a(pos1, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(playerIn, 2001, pos1, Block.func_196246_j((BlockState)state1));
            ItemStack stack = playerIn.func_184614_ca();
            if (!worldIn.field_72995_K && !playerIn.func_184812_l_() && playerIn.func_184823_b(state1)) {
                Block.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)playerIn, (ItemStack)stack);
                Block.func_220054_a((BlockState)state1, (World)worldIn, (BlockPos)pos1, (TileEntity)null, (Entity)playerIn, (ItemStack)stack);
            }
        }
        super.func_176208_a(worldIn, pos, state, playerIn);
    }

    public void func_180657_a(World worldIn, PlayerEntity playerIn, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, playerIn, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, H_FACING, OPEN, HINGE, WATERLOGGED});
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.AXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag tipFlag) {
        super.func_190948_a(stack, worldIn, tooltip, tipFlag);
        tooltip.add(new TranslationTextComponent("tips.block_window", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }
}

