/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.ayutaki.chinjufumod.blocks.kitchen.ReizouTop;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.handler.TileEntity_CM;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class ReizouTop_TileEntity
extends LockableLootTileEntity
implements IChestLid,
ITickableTileEntity {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)45, (Object)ItemStack.field_190927_a);
    protected float openness;
    protected float oOpenness;
    protected int openCount;
    private int tickInterval;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    protected ReizouTop_TileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public ReizouTop_TileEntity() {
        this(TileEntity_CM.REIZOU_TOP);
    }

    public int func_70302_i_() {
        return 27;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest");
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        }
        return compound;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.tickInterval;
        this.openCount = ReizouTop_TileEntity.getOpenCount(this.field_145850_b, (LockableTileEntity)this, this.tickInterval, i, j, k, this.openCount);
        this.oOpenness = this.openness;
        if (this.openCount > 0 && this.openness == 0.0f) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)ReizouTop.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playSound(SoundEvents_CM.REIZOU_OPEN);
        }
        if (this.openCount == 0 && this.openness > 0.0f || this.openCount > 0 && this.openness < 1.0f) {
            float f2;
            float f1 = this.openness;
            this.openness = this.openCount > 0 ? (this.openness += 0.1f) : (this.openness -= 0.1f);
            if (this.openness > 1.0f) {
                this.openness = 1.0f;
            }
            if (this.openness < (f2 = 0.5f) && f1 >= f2) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)ReizouTop.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playSound(SoundEvents_CM.REIZOU_CLOSE);
            }
            if (this.openness < 0.0f) {
                this.openness = 0.0f;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)ReizouTop.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public static int getOpenCount(World worldIn, LockableTileEntity lTileEntity, int ticksSinceSync, int x, int y, int z, int numPlayerUsing) {
        if (!worldIn.field_72995_K && numPlayerUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayerUsing = ReizouTop_TileEntity.getOpenCount(worldIn, lTileEntity, x, y, z);
        }
        return numPlayerUsing;
    }

    public static int getOpenCount(World worldIn, LockableTileEntity lTileEntity, int x, int y, int z) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerIn : worldIn.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - f), (double)((float)y - f), (double)((float)z - f), (double)((float)(x + 1) + f), (double)((float)(y + 1) + f), (double)((float)(z + 1) + f)))) {
            IInventory iinventory;
            if (!(playerIn.field_71070_bA instanceof ChestContainer) || (iinventory = ((ChestContainer)playerIn.field_71070_bA).func_85151_d()) != lTileEntity) continue;
            ++i;
        }
        return i;
    }

    private void playSound(SoundEvent sound) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity playerIn) {
        if (!playerIn.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.signalOpenCount();
        }
    }

    public void func_174886_c(PlayerEntity playerIn) {
        if (!playerIn.func_175149_v()) {
            --this.openCount;
            this.signalOpenCount();
        }
    }

    protected void signalOpenCount() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ReizouTop) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.openCount);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> stack) {
        this.items = stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float count) {
        return MathHelper.func_219799_g((float)count, (float)this.oOpenness, (float)this.openness);
    }

    public static int getOpenCount(IBlockReader worldIn, BlockPos pos) {
        TileEntity tileentity;
        BlockState state = worldIn.func_180495_p(pos);
        if (state.hasTileEntity() && (tileentity = worldIn.func_175625_s(pos)) instanceof ReizouTop_TileEntity) {
            return ((ReizouTop_TileEntity)tileentity).openCount;
        }
        return 0;
    }

    public static void swapContents(ReizouTop_TileEntity tileEntity, ReizouTop_TileEntity otherTileEntity) {
        NonNullList<ItemStack> nonnulllist = tileEntity.func_190576_q();
        tileEntity.func_199721_a(otherTileEntity.func_190576_q());
        otherTileEntity.func_199721_a(nonnulllist);
    }

    protected Container func_213906_a(int id, PlayerInventory inventory) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)inventory, (IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ReizouTop)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ReizouTop.getContainer((ReizouTop)state.func_177230_c(), state, this.func_145831_w(), this.func_174877_v(), true);
        return new InvWrapper((IInventory)(inv == null ? this : inv));
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

