/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.tileentity;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractStoveTileEntity
extends AbstractFurnaceTileEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    protected NonNullList<ItemStack> field_214012_a = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    protected final IIntArray field_214013_b = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractStoveTileEntity.this.litTime;
                }
                case 1: {
                    return AbstractStoveTileEntity.this.litDuration;
                }
                case 2: {
                    return AbstractStoveTileEntity.this.cookingProgress;
                }
                case 3: {
                    return AbstractStoveTileEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractStoveTileEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    AbstractStoveTileEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    AbstractStoveTileEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    AbstractStoveTileEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final IRecipeType<? extends AbstractCookingRecipe> field_214014_c;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected AbstractStoveTileEntity(TileEntityType<?> tileTypeIn, IRecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileTypeIn, recipeTypeIn);
        this.field_214014_c = recipeTypeIn;
    }

    @Deprecated
    public static Map<Item, Integer> getFuel() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151129_at, 20000);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150402_ci, 16000);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151072_bj, 2400);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151044_h, 1600);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_196155_l, 1600);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_200038_h, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_199905_b, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_202898_h, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_202899_i, 150);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_212188_k, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_202900_j, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180407_aO, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180404_aQ, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180408_aP, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180403_aR, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180406_aS, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180405_aT, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180390_bo, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180392_bq, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180391_bp, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180386_br, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180385_bs, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_180387_bt, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_196586_al, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150342_X, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222428_lQ, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150421_aI, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150486_ae, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150447_bR, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150462_ai, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150453_bW, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_202901_n, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151031_f, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151112_aM, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_150468_ap, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_219773_J, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151038_n, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151041_m, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151017_I, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151053_p, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151039_o, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_200154_g, 200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_202902_o, 1200);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_199904_a, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_200153_d, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151055_y, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_200037_g, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_151054_z, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (ITag<Item>)ItemTags.field_200035_e, 67);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_203216_jz, 4001);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Items.field_222114_py, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222405_kQ, 50);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_196555_aI, 100);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222420_lI, 400);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222421_lJ, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222422_lK, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222425_lN, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222426_lO, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222429_lR, 300);
        AbstractStoveTileEntity.add((Map<Item, Integer>)map, (IItemProvider)Blocks.field_222436_lZ, 300);
        return map;
    }

    private static boolean isNeverAFurnaceFuel(Item item) {
        return ItemTags.field_232905_P_.func_230235_a_((Object)item);
    }

    private static void add(Map<Item, Integer> map, ITag<Item> itemProvider, int burnTimeIn) {
        for (Item item : itemProvider.func_230236_b_()) {
            if (AbstractStoveTileEntity.isNeverAFurnaceFuel(item)) continue;
            map.put(item, burnTimeIn);
        }
    }

    private static void add(Map<Item, Integer> map, IItemProvider itemProvider, int burnTimeIn) {
        Item item = itemProvider.func_199767_j();
        if (AbstractStoveTileEntity.isNeverAFurnaceFuel(item)) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.func_200295_i((ItemStack)null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, burnTimeIn);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.field_214012_a = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.field_214012_a);
        this.litTime = compound.func_74762_e("BurnTime");
        this.cookingProgress = compound.func_74762_e("CookTime");
        this.cookingTotalTime = compound.func_74762_e("CookTimeTotal");
        this.litDuration = this.func_213997_a((ItemStack)this.field_214012_a.get(1));
        CompoundNBT compoundnbt = compound.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.litTime);
        compound.func_74768_a("CookTime", this.cookingProgress);
        compound.func_74768_a("CookTimeTotal", this.cookingTotalTime);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.field_214012_a);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipesUsed.forEach((p_235643_1_, p_235643_2_) -> compoundnbt.func_74768_a(p_235643_1_.toString(), p_235643_2_.intValue()));
        compound.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isLit();
        boolean flag1 = false;
        if (this.isLit()) {
            --this.litTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = (ItemStack)this.field_214012_a.get(1);
            if (this.isLit() || !stack.func_190926_b() && !((ItemStack)this.field_214012_a.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isLit() && this.func_214008_b(irecipe)) {
                    this.litDuration = this.litTime = this.func_213997_a(stack);
                    if (this.isLit()) {
                        flag1 = true;
                        if (stack.hasContainerItem()) {
                            this.field_214012_a.set(1, (Object)stack.getContainerItem());
                        } else if (!stack.func_190926_b()) {
                            stack.func_190918_g(1);
                            if (stack.func_190926_b()) {
                                this.field_214012_a.set(1, (Object)stack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isLit() && this.func_214008_b(irecipe)) {
                    ++this.cookingProgress;
                    if (this.cookingProgress == this.cookingTotalTime) {
                        this.cookingProgress = 0;
                        this.cookingTotalTime = this.func_214005_h();
                        this.burn(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookingProgress = 0;
                }
            } else if (!this.isLit() && this.cookingProgress > 0) {
                this.cookingProgress = MathHelper.func_76125_a((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
            }
            if (flag != this.isLit()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isLit())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean func_214008_b(@Nullable IRecipe<?> recipe) {
        if (!((ItemStack)this.field_214012_a.get(0)).func_190926_b() && recipe != null) {
            ItemStack stack = recipe.func_77571_b();
            if (stack.func_190926_b()) {
                return false;
            }
            ItemStack stack1 = (ItemStack)this.field_214012_a.get(2);
            if (stack1.func_190926_b()) {
                return true;
            }
            if (!stack1.func_77969_a(stack)) {
                return false;
            }
            if (stack1.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && stack1.func_190916_E() + stack.func_190916_E() <= stack1.func_77976_d()) {
                return true;
            }
            return stack1.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
        }
        return false;
    }

    private void burn(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.func_214008_b(recipe)) {
            ItemStack stack = (ItemStack)this.field_214012_a.get(0);
            ItemStack stack1 = recipe.func_77571_b();
            ItemStack stack2 = (ItemStack)this.field_214012_a.get(2);
            if (stack2.func_190926_b()) {
                this.field_214012_a.set(2, (Object)stack1.func_77946_l());
            } else if (stack2.func_77973_b() == stack1.func_77973_b()) {
                stack2.func_190917_f(stack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (stack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.field_214012_a.get(1)).func_190926_b() && ((ItemStack)this.field_214012_a.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.field_214012_a.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            stack.func_190918_g(1);
        }
    }

    protected int func_213997_a(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, this.field_214014_c) / 2 * 3;
    }

    protected int func_214005_h() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.field_214014_c, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public int[] func_180463_a(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean func_180462_a(int count, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(count, stack);
    }

    public boolean func_180461_b(int count, ItemStack stack, Direction direction) {
        Item item;
        return direction != Direction.DOWN || count != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.field_214012_a.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.field_214012_a) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int count) {
        return (ItemStack)this.field_214012_a.get(count);
    }

    public ItemStack func_70298_a(int count1, int count2) {
        return ItemStackHelper.func_188382_a(this.field_214012_a, (int)count1, (int)count2);
    }

    public ItemStack func_70304_b(int count) {
        return ItemStackHelper.func_188383_a(this.field_214012_a, (int)count);
    }

    public void func_70299_a(int count, ItemStack stack) {
        ItemStack countStack = (ItemStack)this.field_214012_a.get(count);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(countStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)countStack);
        this.field_214012_a.set(count, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (count == 0 && !flag) {
            this.cookingTotalTime = this.func_214005_h();
            this.cookingProgress = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity playerIn) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return playerIn.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int count, ItemStack stack) {
        if (count == 2) {
            return false;
        }
        if (count != 1) {
            return true;
        }
        ItemStack countStack = (ItemStack)this.field_214012_a.get(1);
        return AbstractStoveTileEntity.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && countStack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_174888_l() {
        this.field_214012_a.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    private static void createExperience(World worldIn, Vector3d v3d, int count, float count_f) {
        int i = MathHelper.func_76141_d((float)((float)count * count_f));
        float f = MathHelper.func_226164_h_((float)((float)count * count_f));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            worldIn.func_217376_c((Entity)new ExperienceOrbEntity(worldIn, v3d.field_72450_a, v3d.field_72448_b, v3d.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack stack : this.field_214012_a) {
            helper.func_194112_a(stack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

