/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.entity.Explosion_CM;
import com.ayutaki.chinjufumod.handler.EntityTypes_CM;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.ayutaki.chinjufumod.registry.Items_Weapon;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class Gyorai61cmEntity
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> DATA_ITEM_STACK = EntityDataManager.func_187226_a(Gyorai61cmEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> ID_FLAGS = EntityDataManager.func_187226_a(Gyorai61cmEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private ItemStack projectile = new ItemStack((IItemProvider)Items_Weapon.GYORAI_61cm);
    private double baseDamage = 10.0;

    public Gyorai61cmEntity(EntityType<Gyorai61cmEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public Gyorai61cmEntity(LivingEntity entity, World worldIn, ItemStack stack) {
        super(EntityTypes_CM.GYORAI61, entity, worldIn);
        this.projectile = stack.func_77946_l();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_ITEM_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ID_FLAGS, (Object)0);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= 60) {
            this.dropAndKill();
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        stack.func_190920_e(1);
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)item);
        this.func_70106_y();
    }

    private ItemStack getItemStack() {
        return this.projectile.func_77946_l();
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.func_230299_a_((BlockRayTraceResult)result);
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        double atackDamage = this.baseDamage;
        float criticalA = this.field_70146_Z.nextInt(3) == 0 ? 1.2f : 1.0f;
        float criticalB = this.field_70146_Z.nextInt(9) == 0 ? 1.1f : 0.9f;
        float addGYORAI = this.isSuirai() ? criticalA : criticalB;
        result.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), (float)atackDamage * addGYORAI);
        this.hitProcess();
        this.func_70106_y();
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        BlockState state = this.field_70170_p.func_180495_p(result.func_216350_a());
        state.func_215690_a(this.field_70170_p, state, result, (ProjectileEntity)this);
        Block block = state.func_177230_c();
        if (state.func_185904_a().func_76222_j() || block == Blocks.field_203214_jx) {
            return;
        }
        if (!state.func_185904_a().func_76222_j() && block != Blocks.field_203214_jx) {
            this.hitProcess();
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        if (this.field_205013_W) {
            return 0.0f;
        }
        return 0.01f;
    }

    public boolean func_70090_H() {
        return false;
    }

    public void setSuirai(boolean flag) {
        this.setFlag(1, flag);
    }

    protected void setFlag(int value, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 | value)));
        } else {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 & ~value)));
        }
    }

    public boolean isSuirai() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public void setItem(ItemStack stack) {
        if (stack.func_77973_b() != this.getDefaultItem() || stack.func_77942_o()) {
            this.func_184212_Q().func_187227_b(DATA_ITEM_STACK, Util.func_200696_a((Object)stack.func_77946_l(), consumer -> consumer.func_190920_e(1)));
        }
    }

    protected Item getDefaultItem() {
        return this.projectile.func_77973_b();
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_ITEM_STACK);
    }

    public ItemStack func_184543_l() {
        ItemStack stack = this.getItemRaw();
        return stack.func_190926_b() ? new ItemStack((IItemProvider)this.getDefaultItem()) : stack;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack stack = this.getItemRaw();
        if (!stack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74780_a("damage", this.baseDamage);
        compound.func_74757_a("suirai", this.isSuirai());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setItem(stack);
        if (compound.func_150297_b("damage", 99)) {
            this.baseDamage = compound.func_74769_h("damage");
        }
        this.setSuirai(compound.func_74767_n("suirai"));
    }

    public void setBaseDamage(double damage) {
        this.baseDamage = damage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void hitProcess() {
        if (!this.field_70170_p.field_72995_K) {
            float addGYORAI = this.isSuirai() ? 1.5f : 1.0f;
            this.createExplosion((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), addGYORAI, false, Explosion.Mode.NONE);
        }
        this.func_184185_a(SoundEvents_CM.AM_IMPACT, 2.0f, 0.8f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
    }

    public Explosion_CM createExplosion(@Nullable Entity entityIn, double xIn, double yIn, double zIn, float value, boolean flag, Explosion.Mode mode) {
        return this.explode(entityIn, null, null, xIn, yIn, zIn, value, flag, mode);
    }

    public Explosion_CM explode(@Nullable Entity entityIn, @Nullable DamageSource damage, @Nullable ExplosionContext context, double xIn, double yIn, double zIn, float value, boolean flag, Explosion.Mode mode) {
        Explosion_CM explosion = new Explosion_CM(this.field_70170_p, (Entity)this, damage, context, xIn, yIn, zIn, value, flag, mode);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

