/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.Config_CM;
import com.ayutaki.chinjufumod.entity.helper.Vector3;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public abstract class AbstractKK_Entity
extends ThrowableEntity
implements IRendersAsItem {
    protected static final DataParameter<ItemStack> DATA_ITEM_STACK = EntityDataManager.func_187226_a(AbstractKK_Entity.class, (IDataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Byte> ID_FLAGS = EntityDataManager.func_187226_a(AbstractKK_Entity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> RETURN_TO = EntityDataManager.func_187226_a(AbstractKK_Entity.class, (IDataSerializer)DataSerializers.field_187192_b);

    protected AbstractKK_Entity(EntityType<? extends AbstractKK_Entity> type, World worldIn) {
        super(type, worldIn);
    }

    protected AbstractKK_Entity(EntityType<? extends AbstractKK_Entity> type, double posX, double posY, double posZ, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    protected AbstractKK_Entity(EntityType<? extends AbstractKK_Entity> type, LivingEntity shooter, World worldIn) {
        this(type, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.func_212361_a((Entity)shooter);
        if (Config_CM.getInstance().lowSound()) {
            this.func_184185_a(SoundEvents_CM.KK_PROPELLER_12, 1.5f, 1.0f);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_ITEM_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ID_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(RETURN_TO, (Object)-1);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double dist) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return dist < (d0 *= 64.0) * d0;
    }

    public void func_70071_h_() {
        float f;
        super.func_70071_h_();
        if (!Config_CM.getInstance().lowSound() && this.field_70173_aa % 3 == 0) {
            this.func_184185_a(SoundEvents_CM.KK_PROPELLER, 1.5f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity thrower = this.func_234616_v_();
            if (this.isReturning()) {
                if (thrower == null && this.field_70173_aa > 200) {
                    this.dropAndKill();
                }
                if (thrower != null) {
                    Vector3 motion = Vector3.fromEntityCenter(thrower).subtract(Vector3.fromEntityCenter((Entity)this)).normalize();
                    this.func_213317_d(motion.toVector3d());
                    if (this.func_70068_e(thrower) < 2.0) {
                        this.dropAndKill();
                    }
                }
            }
            if (!this.isReturning()) {
                if (thrower == null && this.field_70173_aa > 200) {
                    this.dropAndKill();
                }
                if (thrower != null && this.field_70173_aa >= 60) {
                    this.setEntityToReturnTo(this.getEntityToReturnTo() + 1);
                }
            }
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((AbstractKK_Entity)this).func_230298_a_(arg_0));
        boolean flag = false;
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
                flag = true;
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                    ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                }
                flag = true;
            }
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a(raytraceresult);
        }
        this.func_145775_I();
        Vector3d vector3d = this.func_213322_ci();
        double d2 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d0 = this.func_226278_cu_() + vector3d.field_72448_b;
        double d1 = this.func_226281_cx_() + vector3d.field_72449_c;
        this.func_234617_x_();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d2 - vector3d.field_72450_a * 0.25, d0 - vector3d.field_72448_b * 0.25, d1 - vector3d.field_72449_c * 0.25, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.func_213317_d(vector3d.func_186678_a((double)f));
        if (!this.func_189652_ae()) {
            Vector3d vector3d1 = this.func_213322_ci();
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b - (double)this.func_70185_h(), vector3d1.field_72449_c);
        }
        this.func_70107_b(d2, d0, d1);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void dropAndKill() {
        ItemStack stack = this.getItemStack();
        Entity thrower = this.func_234616_v_();
        PlayerEntity playerIn = (PlayerEntity)thrower;
        if (thrower != null && !playerIn.field_71075_bZ.field_75098_d) {
            stack.func_96631_a(1, this.field_70146_Z, null);
        }
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)item);
        this.func_70106_y();
    }

    protected abstract ItemStack getItemStack();

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)result);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            this.func_230299_a_((BlockRayTraceResult)result);
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        BlockState state = this.field_70170_p.func_180495_p(result.func_216350_a());
        state.func_215690_a(this.field_70170_p, state, result, (ProjectileEntity)this);
        this.setCarrier(false);
        Block block = state.func_177230_c();
        if (block instanceof Block) {
            return;
        }
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    protected int getEntityToReturnTo() {
        return (Integer)this.field_70180_af.func_187225_a(RETURN_TO);
    }

    protected void setEntityToReturnTo(int entityID) {
        this.field_70180_af.func_187227_b(RETURN_TO, (Object)entityID);
    }

    public void setCarrier(boolean flag) {
        this.setFlag(1, flag);
    }

    protected void setFlag(int value, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 | value)));
        } else {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 & ~value)));
        }
    }

    public boolean isCarrier() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public void setItem(ItemStack stack) {
        if (stack.func_77973_b() != this.getDefaultItem() || stack.func_77942_o()) {
            this.func_184212_Q().func_187227_b(DATA_ITEM_STACK, Util.func_200696_a((Object)stack.func_77946_l(), consumer -> consumer.func_190920_e(1)));
        }
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_ITEM_STACK);
    }

    public ItemStack func_184543_l() {
        ItemStack stack = this.getItemRaw();
        return stack.func_190926_b() ? new ItemStack((IItemProvider)this.getDefaultItem()) : stack;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack stack = this.getItemRaw();
        if (!stack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("carrier", this.isCarrier());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setItem(stack);
        this.setCarrier(compound.func_74767_n("carrier"));
    }
}

