/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.entity;

import com.ayutaki.chinjufumod.handler.ParticleTypes_CM;
import com.ayutaki.chinjufumod.handler.SoundEvents_CM;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractAmmo_Kijyuu
extends AbstractArrowEntity {
    private static final DataParameter<Byte> ID_FLAGS = EntityDataManager.func_187226_a(AbstractAmmo_Kijyuu.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(AbstractAmmo_Kijyuu.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockState lastState;
    protected boolean field_70254_i;
    protected int field_184552_b;
    public PickupStatus field_70251_a = PickupStatus.DISALLOWED;
    public int field_70249_b;
    private int life;
    private double ammoDamage = 1.0;
    private int knockback;
    private SoundEvent soundEvent = this.func_213867_k();
    private IntOpenHashSet piercingIgnoreEntityIds;
    private List<Entity> piercedAndKilledEntities;
    private boolean leftOwner;

    protected AbstractAmmo_Kijyuu(EntityType<? extends AbstractArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected AbstractAmmo_Kijyuu(EntityType<? extends AbstractArrowEntity> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    protected AbstractAmmo_Kijyuu(EntityType<? extends AbstractArrowEntity> type, LivingEntity shooter, World worldIn) {
        this(type, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_(), worldIn);
        this.func_212361_a((Entity)shooter);
        if (shooter instanceof PlayerEntity) {
            this.field_70251_a = PickupStatus.ALLOWED;
        }
    }

    public void func_213869_a(SoundEvent soundIn) {
        this.soundEvent = soundIn;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ID_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, inaccuracy);
        this.life = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        super.func_70016_h(x, y, z);
        this.life = 0;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos pos;
        BlockState state;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        boolean flag = this.func_203047_q();
        Vector3d vector3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)AbstractAmmo_Kijyuu.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((state = this.field_70170_p.func_180495_p(pos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, pos) || flag || (voxelshape = state.func_196952_d((IBlockReader)this.field_70170_p, pos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(pos).func_72318_a(vector3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        } else {
            Vector3d vector3d3;
            this.field_184552_b = 0;
            Vector3d vector3d2 = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2, vector3d3 = vector3d2.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vector3d3 = raytraceresult.func_216347_e();
            }
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity owner = this.func_234616_v_();
                    if (entity instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.func_213322_ci();
            double d3 = vector3d.field_72450_a;
            double d4 = vector3d.field_72448_b;
            double d0 = vector3d.field_72449_c;
            double d5 = this.func_226277_ct_() + d3;
            double d1 = this.func_226278_cu_() + d4;
            double d2 = this.func_226281_cx_() + d0;
            float f1 = MathHelper.func_76133_a((double)AbstractAmmo_Kijyuu.func_213296_b((Vector3d)vector3d));
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)d3, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d4, (double)f1) * 57.2957763671875);
            this.field_70125_A = AbstractAmmo_Kijyuu.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = AbstractAmmo_Kijyuu.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float f2 = 0.99f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.func_203044_p();
            }
            this.func_213317_d(vector3d.func_186678_a((double)f2));
            if (!this.func_189652_ae() && !flag) {
                Vector3d vector3d4 = this.func_213322_ci();
                this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b - (double)0.05f, vector3d4.field_72449_c);
            }
            this.func_70107_b(d5, d1, d2);
            this.func_145775_I();
        }
        this.func_70030_z();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            for (Entity entity1 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity0 -> !entity0.func_175149_v() && entity0.func_70067_L())) {
                if (entity1.func_184208_bv() != entity.func_184208_bv()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean shouldFall() {
        return this.field_70254_i && this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.06));
    }

    private void startFalling() {
        this.field_70254_i = false;
        Vector3d vector3d = this.func_213322_ci();
        this.func_213317_d(vector3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
        this.life = 0;
    }

    public void func_213315_a(MoverType mover, Vector3d vector3d) {
        super.func_213315_a(mover, vector3d);
        if (mover != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void func_225516_i_() {
        ++this.life;
        if (this.life >= 1000) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        DamageSource damagesource;
        Entity owner;
        Entity entity = result.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * this.ammoDamage), (double)0.0, (double)2.147483647E9));
        if (this.func_213874_s() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.func_145782_y());
        }
        if ((owner = this.func_234616_v_()) == null) {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76356_a((Entity)this, (Entity)owner);
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int k = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (this.knockback > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockback * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && owner instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.func_184548_a(livingentity);
                if (owner != null && livingentity != owner && livingentity instanceof PlayerEntity && owner instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)owner).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!entity.func_70089_S() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
            }
            this.func_184185_a(this.soundEvent, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(k);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        this.lastState = this.field_70170_p.func_180495_p(result.func_216350_a());
        super.func_230299_a_(result);
        Vector3d vector3d = result.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)0.05f);
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        this.func_213872_b((byte)0);
        this.func_213869_a(SoundEvents_CM.AM_HIT);
        this.func_213865_o(false);
        this.resetPiercedEntities();
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents_CM.AM_HIT;
    }

    protected void func_184548_a(LivingEntity entity) {
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d vector3d_1, Vector3d vector3d_2) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)vector3d_1, (Vector3d)vector3d_2, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), this::func_230298_a_);
    }

    protected boolean func_230298_a_(Entity entity) {
        return super.func_230298_a_(entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.func_145782_y()));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("life", (short)this.life);
        if (this.lastState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.lastState));
        }
        compound.func_74774_a("shake", (byte)this.field_70249_b);
        compound.func_74757_a("inGround", this.field_70254_i);
        compound.func_74774_a("pickup", (byte)this.field_70251_a.ordinal());
        compound.func_74780_a("damage", this.ammoDamage);
        compound.func_74757_a("crit", this.func_70241_g());
        compound.func_74774_a("PierceLevel", this.func_213874_s());
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.soundEvent).toString());
        compound.func_74757_a("ShotFromCrossbow", this.func_213873_r());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.life = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.lastState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        this.field_70249_b = compound.func_74771_c("shake") & 0xFF;
        this.field_70254_i = compound.func_74767_n("inGround");
        if (compound.func_150297_b("damage", 99)) {
            this.ammoDamage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.field_70251_a = PickupStatus.byOrdinal(compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.field_70251_a = compound.func_74767_n("player") ? PickupStatus.ALLOWED : PickupStatus.DISALLOWED;
        }
        this.func_70243_d(compound.func_74767_n("crit"));
        this.func_213872_b(compound.func_74771_c("PierceLevel"));
        if (compound.func_150297_b("SoundEvent", 8)) {
            this.soundEvent = Registry.field_212633_v.func_241873_b(new ResourceLocation(compound.func_74779_i("SoundEvent"))).orElse(this.func_213867_k());
        }
        this.func_213865_o(compound.func_74767_n("ShotFromCrossbow"));
    }

    public void func_212361_a(@Nullable Entity entity) {
        super.func_212361_a(entity);
        if (entity instanceof PlayerEntity) {
            this.field_70251_a = ((PlayerEntity)entity).field_71075_bZ.field_75098_d ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    public void func_70100_b_(PlayerEntity entity) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == PickupStatus.ALLOWED || this.field_70251_a == PickupStatus.CREATIVE_ONLY && entity.field_71075_bZ.field_75098_d || this.func_203047_q() && this.func_234616_v_().func_110124_au() == entity.func_110124_au();
            if (this.field_70251_a == PickupStatus.ALLOWED && !entity.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                entity.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected abstract ItemStack func_184550_j();

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70239_b(double damage) {
        this.ammoDamage = damage;
    }

    public double func_70242_d() {
        return this.ammoDamage;
    }

    public void func_70240_a(int knockback) {
        this.knockback = knockback;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose pos, EntitySize size) {
        return 0.13f;
    }

    public void func_70243_d(boolean flag) {
        this.setFlag(1, flag);
    }

    public void func_213872_b(byte value) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)value);
    }

    private void setFlag(int value, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 | value)));
        } else {
            this.field_70180_af.func_187227_b(ID_FLAGS, (Object)((byte)(b0 & ~value)));
        }
    }

    public boolean func_70241_g() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean func_213873_r() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ID_FLAGS);
        return (b0 & 4) != 0;
    }

    public byte func_213874_s() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void func_190547_a(LivingEntity entity, float value) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)entity);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)entity);
        this.func_70239_b((double)(value * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.func_70239_b(this.func_70242_d() + (double)i * 0.5);
        }
        if (j > 0) {
            this.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)entity) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float func_203044_p() {
        return 0.6f;
    }

    public void func_203045_n(boolean flag) {
        this.field_70145_X = flag;
        this.setFlag(2, flag);
    }

    public boolean func_203047_q() {
        if (!this.field_70170_p.field_72995_K) {
            return this.field_70145_X;
        }
        return ((Byte)this.field_70180_af.func_187225_a(ID_FLAGS) & 2) != 0;
    }

    public void func_213865_o(boolean flag) {
        this.setFlag(4, flag);
    }

    public IPacket<?> func_213297_N() {
        Entity owner = this.func_234616_v_();
        return new SSpawnObjectPacket((Entity)this, owner == null ? 0 : owner.func_145782_y());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes_CM.MARK_PT, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static PickupStatus byOrdinal(int value) {
            if (value < 0 || value > PickupStatus.values().length) {
                value = 0;
            }
            return PickupStatus.values()[value];
        }
    }
}

