/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.blocks.wood;

import com.ayutaki.chinjufumod.registry.Wood_Blocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class FallLeaf
extends GrassBlock {
    public FallLeaf(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item instanceof ShovelItem) {
            stack.func_222118_a(1, (LivingEntity)playerIn, user -> user.func_213334_d(hand));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3);
            return ActionResultType.SUCCESS;
        }
        if (item instanceof HoeItem) {
            stack.func_222118_a(1, (LivingEntity)playerIn, user -> user.func_213334_d(hand));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(pos, Wood_Blocks.SUIDEN.func_176223_P(), 3);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static boolean canBeGrass(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos upPos = pos.func_177984_a();
        BlockState upState = worldIn.func_180495_p(upPos);
        if (upState.func_177230_c() == Blocks.field_150433_aE && (Integer)upState.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)worldIn, (BlockState)state, (BlockPos)pos, (BlockState)upState, (BlockPos)upPos, (Direction)Direction.UP, (int)upState.func_200016_a((IBlockReader)worldIn, upPos));
        return i < worldIn.func_201572_C();
    }

    private static boolean canPropagate(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos upPos = pos.func_177984_a();
        return FallLeaf.canBeGrass(state, worldIn, pos) && !worldIn.func_204610_c(upPos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!FallLeaf.canBeGrass(state, (IWorldReader)worldIn, pos)) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 3);
        } else if (worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
            BlockState defaultState = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos nearPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (worldIn.func_180495_p(nearPos).func_177230_c() != Blocks.field_150346_d || !FallLeaf.canPropagate(defaultState, (IWorldReader)worldIn, nearPos)) continue;
                worldIn.func_180501_a(nearPos, (BlockState)defaultState.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(nearPos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE)), 3);
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return true;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.SHOVEL;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag tipFlag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tips.block_fall_leaf").func_240699_a_(TextFormatting.GRAY));
    }
}

